/* Web service harvester....
 Copyright (c) 2000-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.
 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.
 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
 */

package org.sdm.spa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.xpath.XPathAPI;
import org.ecoinformatics.seek.sms.AnnotationEngine;
import org.ecoinformatics.seek.sms.KeplerLocalLSIDService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.type.BaseType;
import ptolemy.gui.MessageHandler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.EntityLibrary;

//////////////////////////////////////////////////////////////////////////
//// WSHarvester
/** Given a repository as a parameter, this actor generates a folders for all
    the web services in this repository under the superfolder called
    "webservices". Under each web service folder, it generates actors for all
    the operations of the webservice specified by its wsdl.
    @author Ilkay Altintas
    @version $Id: WSHarvester.java,v 1.18 2005/11/01 20:39:14 ruland Exp $
 */

public class WSHarvester
    extends TypedAtomicActor {
  /** Construct a WebService actor with the given container and name.
   *  @param container The container.
   *  @param name The name of this actor.
   *  @exception IllegalActionException If the actor cannot be contained
   *   by the proposed container.
   *  @exception NameDuplicationException If the container already has an
   *   actor with this name.
   */
  public WSHarvester(CompositeEntity container, String name) throws
      NameDuplicationException, IllegalActionException {

    super(container, name);

    repositoryURL = new FileParameter(this, "repositoryURL");
    keywords = new StringAttribute(this, "keywords");

    _attachText("_iconDescription",
                "<svg>\n"
                + "<rect x=\"0\" y=\"0\" "
                + "width=\"80\" height=\"40\" "
                + "style=\"fill:white\"/>\n"
                + "</svg>\n");
  } // end of constructor

  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////

  // The url or the path of the wsdl list/repository.
  public FileParameter repositoryURL;
  // The keywords for the selection of web services.
  public StringAttribute keywords;

  public File WSmomlfile;
  ///////////////////////////////////////////////////////////////////
  ////                        public methods                     ////

  /** Callback for changes in attribute values
   *  Get the file or url selected.
   *
   *  @param a The attribute that changed.
   *  @exception IllegalActionException If the offsets array is not
   *   nondecreasing and nonnegative.
   */
  public void attributeChanged(Attribute at) throws IllegalActionException {

    if (at == repositoryURL) {
      // FIX ME: I'm no sure what to do when the user changes the wsdl
      //       list/repository. We can either clean the pre-constructed folders,
      //       or we can add new actors. The actor folder will be too big if
      //       we don't delete the actors.
    } //end of if (at == wsdlUrl)

  } // end of attributeChanged

  /** Grab the WSDL urls from the file or repository url given.
   *
   *  @exception IllegalActionException If there is no director.
   */
  public void fire() throws IllegalActionException {
    super.fire();

    try {
      String strRepositoryURL = repositoryURL.getExpression();
      if (!strRepositoryURL.trim().startsWith("http://")) { // it is a file name
        File file = repositoryURL.asFile();
        _in = new FileReader(file);
      } // end of if (!strrepositoryURL.trim().startsWith("http"))
      else {
        URL url = new URL(strRepositoryURL);
        HttpURLConnection urlconn = (HttpURLConnection) url.openConnection();
        _in = new InputStreamReader(urlconn.getInputStream());
      }
      BufferedReader br = new BufferedReader(_in);
      String line = "";
      while ( (line = br.readLine()) != null) {
      	int hrefInd = line.toLowerCase().indexOf("href");
      	if (hrefInd != -1) {  // TODO: needs to be modified to take care of other urls in the line
	        line = line.substring(hrefInd);
      		int indBegin = line.toLowerCase().indexOf("http://");
	        int indEnd = line.toLowerCase().indexOf(".wsdl");
	        if (indEnd == -1) {
	        	indEnd = line.toLowerCase().indexOf("?wsdl");
	        }
	        if (! (indBegin == -1) && ! (indEnd == -1)) {
	          String wsdlUrl = line.substring(indBegin , indEnd + 5);
	          //result.broadcast(new StringToken(wsdlUrl));
	          wsdlUrl = wsdlUrl.replaceAll("%2F", "/");
	          wsdlUrl = wsdlUrl.replaceAll("%3A", ":");
	          indBegin = wsdlUrl.toLowerCase().lastIndexOf("http");
	          wsdlUrl = wsdlUrl.substring(indBegin);
	          int slashIndex = wsdlUrl.lastIndexOf('/');
	          String folderName = wsdlUrl.substring(slashIndex + 1,
	                                                wsdlUrl.length() - 5);
	          /* Pseudocode for the implementation of the harvesting after this point:
	           * 1. Get the content of the "wsdlUrl" into _wsdlStr
	           */
	          try {
	            //System.out.println("Getting the content of the wsdlUrl: " + wsdlUrl);
	            URL url = new URL(wsdlUrl);
	            HttpURLConnection urlconn =
	                (HttpURLConnection) url.openConnection();
	            BufferedReader in = new BufferedReader(new InputStreamReader(
	                urlconn.
	                getInputStream()));
	            _WSDLStr = "";
	            String wsdlLine = "";
	            wsdlLine = in.readLine();
	            _WSDLStr += wsdlLine;
	            while (true) {
	              wsdlLine = in.readLine();
	              if (wsdlLine == null)
	                break;
	              _WSDLStr += '\n' + wsdlLine;
	            }
	            in.close();
	            urlconn.disconnect();
	          }
	          catch (Exception e) {
	            KernelException.stackTraceToString(e);
	            System.out.println(e + "\n");
	          }

	          /* 3. Parse wsdlStr
	           * 4. Get names of the operations
	           * 5. For each operation
	           *      6. get input-output message
	           *      7. get part names and their types
	           *      8. create an actor for each operation
	           */
	          try {
	            // Parse the WSDL into a DOM object.
	           // System.out.println(_WSDLStr);
	            DocumentBuilderFactory factory =
	                DocumentBuilderFactory.newInstance();
	            factory.setValidating(false);
	            DocumentBuilder parser = factory.newDocumentBuilder();
	            InputSource in = new InputSource(new StringReader(_WSDLStr));
	            Document doc = parser.parse(in);

	            // Query the input message for the given operation (method).
	            String xPath = "//portType/operation";
	            Node contextNode = doc.getDocumentElement();
	            NodeIterator nodeIter =
	                XPathAPI.selectNodeIterator(contextNode, xPath);
	            Node node;
	            // For each node
	            //_momlStr += "<entity name=\"" + folderName + "\" class=\"ptolemy.moml.EntityLibrary\">\n";
	            
	            while ( (node = nodeIter.nextNode()) != null) {
	              _methodNameStr = ( (Element) node).getAttribute("name");
	              
	              KeplerLocalLSIDService service = KeplerLocalLSIDService.instance();
	              AnnotationEngine engine = AnnotationEngine.instance();
	              String namespace = folderName + "_" + _methodNameStr;           
	              WebServiceStub wss = new WebServiceStub(new EntityLibrary(), namespace);
	              wss.wsdlUrl.setExpression(wsdlUrl);
	              wss.methodName.setExpression(_methodNameStr);
	              try {

	               // Query the input message for the given operation (method).
	                xPath = "//portType/operation[@name=\"" + _methodNameStr +
	                    "\"]/input";
	                contextNode = doc.getDocumentElement();
	                NodeIterator nodeIterInMess =
	                    XPathAPI.selectNodeIterator(contextNode, xPath);
	                // For each node
	                while ( (node = nodeIterInMess.nextNode()) != null) {
	                  _inMessage = ( (Element) node).getAttribute("name");
	                }

	                // Query the output message for the given operation (method).
	                xPath = "//portType/operation[@name=\"" + _methodNameStr +
	                    "\"]/output";
	                contextNode = doc.getDocumentElement();
	                NodeIterator nodeIterOutMess = XPathAPI.selectNodeIterator(contextNode, xPath);
	                // For each node
	                while ( (node = nodeIterOutMess.nextNode()) != null) {
	                  _outMessage = ( (Element) node).getAttribute("name");
	                }

	                // Query the parts of the queried input message.
	                xPath = "//message[@name=\"" + _inMessage +
	                    "\"]/part";
	                contextNode = doc.getDocumentElement();
	                NodeIterator nodeIterInput = XPathAPI.selectNodeIterator(contextNode, xPath);
	                String partName = "";
	                String typeStr = "";
	                // For each node
	                while ( (node = nodeIterInput.nextNode()) != null) {
	                  partName = ( (Element) node).getAttribute("name");
	                  typeStr = ( (Element) node).getAttribute("type");

	                  TypedIOPort inp = (TypedIOPort) wss.newPort(partName);
	    	  	         inp.setTypeEquals(BaseType.STRING);
	    	  	         //Change the line above with:
	    	  	         // inp.setTypeEquals(convertTypeToPTIIType(typestr));
	    	  	         inp.setInput(true);
	                }

	                // Query the parts of the queried outputput message.
	                xPath = "//message[@name=\"" + _outMessage +
	                    "\"]/part";
	                contextNode = doc.getDocumentElement();
	                NodeIterator nodeIterOutput = XPathAPI.selectNodeIterator(contextNode, xPath);
	                partName = "";
	                typeStr = "";
	                // For each node
	                while ( (node = nodeIterOutput.nextNode()) != null) {
	                  partName = ( (Element) node).getAttribute("name");
	                  typeStr = ( (Element) node).getAttribute("type");

	                  TypedIOPort outp = (TypedIOPort) wss.newPort(partName);
	    	  	         outp.setTypeEquals(BaseType.STRING);
	    	  	         //Change the line above with:
	    	  	         // outp.setTypeEquals(convertTypeToPTIIType(typestr));
	    	  	         outp.setOutput(true);
	                }
	             
	              Iterator lsidIter = service.getLSIDFor(wss);
	              if (!lsidIter.hasNext()) {
	      	         String newLSID = service.createLocallyUniqueLSID(namespace);
	      	         service.assignLSID(newLSID, wss);
	      	         engine.addActorAnnotation(newLSID, "PreConfiguredWebServiceActor");
	      	         System.out.println("NEW: " + newLSID);
	              }
	              else {
	              	while (lsidIter.hasNext()) {
	              		String nextLSID = (String) lsidIter.next();
	              		service.updateLSID(nextLSID, wss);
	              		engine.addActorAnnotation(nextLSID, "PreConfiguredWebServiceActor");
	              		System.out.println("UPDATE: " + nextLSID);
	              	}
	              }
	      	      service.commitChanges();
	              }
	              catch (Exception e) {
	                System.out.println(e);
	              }
	            }
	            
	            /* 9. Dynamically update folders with the new webservices.xml file.
	             *
	             * WSStub is a class that executes a specified web service.
	             * This class will be used to execute the web services in the harvester.
	             *
	             */
	          }
	          catch (Exception e) {
	            System.out.println(e);
	          }

	          //System.out.println(_momlStr);
	        }
      	}
      }

      _in.close();
      br.close();

    }
    catch (Exception ex) {
      MessageHandler.error(
          "Error opening/updating one of the input or parameter files: ", ex);
    }
  } // end of fire

  /** There's nothing to initialize currently.
   *  @exception IllegalActionException If the parent class throws it.
   */
  public void initialize() throws IllegalActionException {
    super.initialize();
    _WSDLStr = "";
   // _momlStr = "";
  } // end of initialize

  /** Post fire the actor. Return false to indicate that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   */
  public boolean postfire() {
    return false;
  } // end of postfire

  /** Pre fire the actor.
   *  Calls the super class's prefire in case something is set there.
   */
  public boolean prefire() throws IllegalActionException {
    return super.prefire();
  } // end of prefire

  //////////////////////////////////////////////////////////////////////
  ////                         private variables                    ////

  // The WSDL string
  String _WSDLStr = "";
  // The name of the method that this web service actor binds to
  String _methodNameStr = new String();
  // Input and output messages of the web service
  public String _inMessage;
  public String _outMessage;

  private Reader _in;
}