/*
 * A File locating actor from SKIDLkit @ SDSC...
 *
 * Copyright (c) 2000-2003 The Regents of the University of California. All
 * rights reserved. Permission is hereby granted, without written agreement and
 * without license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the above
 * copyright notice and the following two paragraphs appear in all copies of
 * this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN
 * "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * PT_COPYRIGHT_VERSION_2 COPYRIGHTENDKEY
 */
package org.skidlkit;
import java.io.File;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.gui.MessageHandler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.data.expr.FileParameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
//////////////////////////////////////////////////////////////////////////
////FileLocator
/**
 * This actor find a file location and output the location to Trainer Actor
 *
 * @author Longjiang Ding
 * @version $Id: FileLocator.java,v 1.2 2004/07/23 04:44:38 altintas Exp $
 * @since Ptolemy II 3.0.2
 */
public class FileLocator extends TypedAtomicActor {
	/**
	 * Construct a FileLocator actor with the given container and name.
	 *
	 * @param container
	 *            The container.
	 * @param name
	 *            The name of this actor.
	 * @exception IllegalActionException
	 *                If the actor cannot be contained by the proposed
	 *                container.
	 * @exception NameDuplicationException
	 *                If the container already has an actor with this name.
	 */
	public FileLocator(CompositeEntity container, String name)
			throws IllegalActionException, NameDuplicationException {
		super(container, name);
		input = new TypedIOPort(this, "input", true, false);
		input.setTypeEquals(BaseType.STRING);
		output = new TypedIOPort(this, "output", false, true);
		output.setTypeEquals(BaseType.STRING);
		filename = new FileParameter(this, "filename");
		filename
				.setExpression("browse <input file name> if input port not used");
		_attachText("_iconDescription", "<svg>\n"
				+ "<rect x=\"-25\" y=\"-20\" " + "width=\"50\" height=\"40\" "
				+ "style=\"fill:white\"/>\n"
				+ "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
				+ " 15,-10 15,10, -15,10\" " + "style=\"fill:orange\"/>\n"
				+ "</svg>\n");
	} // end of constructor
	///////////////////////////////////////////////////////////////////
	//// ports and parameters ////
	/**
	 * The local input & output file names
	 */
	public TypedIOPort input;
	public TypedIOPort output;
	public FileParameter filename;
	///////////////////////////////////////////////////////////////////
	//// public methods ////
	/**
	 * Read the input file name string if it is other than null, and then fire
	 * the external executable code ...
	 *
	 * @exception IllegalActionException
	 *                If there's no director.
	 */
	public void fire() throws IllegalActionException {
		if (input.getWidth() != 0) { // get input from input port
			try {
				if (input.hasToken(0)) {
					//If the inputToken is null set reFire to false.
					StringToken inToken = null;
					try {
						inToken = (StringToken) input.get(0);
					} catch (Exception ex) {
					}
					if (inToken != null) {
						// set up command
						output.send(0, inToken);
					} else {
						MessageHandler.error("NoTokenException");
					}
				}
			} catch (Exception e) {
				MessageHandler.error(
						"Error opening/updating one of the input parameters: ",
						e);
			}
		} else { // otherwise use FileAttribute filename's value
			File file = filename.asFile();
			if(file.exists()){
				output.send(0, new StringToken(filename.getExpression()));
			} else {
				System.out.println("please stop the run and configure \""+ this.getName() + "\" to have the correct input file name");
			}
		}
	} // end of fire
}