/* updatedd warenty thing

*/

package ptolemy.actor;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.graph.DirectedGraph;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;

//////////////////////////////////////////////////////////////////////////
//// ModelDependencyGraph

/** This class will generate a ptolemy DirectedGraph the represnts
    the model.  Based on FunctionDependency classes in actor/util
    
    @author Oscar Barney
    @version $Id: ModelDependencyGraph.java,v 1.1 2005/11/02 21:34:45 barney Exp $
*/

public class ModelDependencyGraph {
    
    /** Do nothing really... only has a public static function
     *  
     */
    public ModelDependencyGraph(){
        
    }
    
    /** make and return the graph
    */
    public static DirectedGraph generateDependencyGraph
            (CompositeActor compositeActor) {
        return _constructDependencyGraph(compositeActor);
    }
    
    
    ///////////////////////////////////////////////////////////////////
    ////                   protected methods                   ////
    
    /** Construct a dependency graph from a 
     */
    protected static DirectedGraph _constructDependencyGraph
            (Actor actor) {
        
        DirectedGraph temp = new DirectedGraph();
        
        // include all the externally visible ports of the associated actor
        // as nodes in the graph
        Iterator inputs = actor.inputPortList().listIterator();
        while (inputs.hasNext()) {
            IOPort input = (IOPort) inputs.next();
            temp.addNodeWeight(input);
        }
        Iterator outputs = actor.outputPortList().listIterator();
        while (outputs.hasNext()) {
            IOPort output = (IOPort) outputs.next();
            temp.addNodeWeight(output);
        }

        if (actor instanceof CompositeActor) {
            List embeddedActors = ((CompositeActor) actor).entityList();

            // Merge graphs of the internal actors into 
            // the graph of this actor.
            Iterator embeddedActorsIterator = embeddedActors.iterator();
            while (embeddedActorsIterator.hasNext()) {
                temp.addGraph(_constructDependencyGraph
                        ((Actor)embeddedActorsIterator.next()));
            }
            
            //Now we will add all of the edges that belong in this composite actor.
            List outputPorts = actor.outputPortList();
            embeddedActorsIterator = embeddedActors.iterator();
    
            //Iterate over all of the embedded actors .
            while (embeddedActorsIterator.hasNext()) {
                Actor embeddedActor = (Actor) embeddedActorsIterator.next();
    
                // Find the successor of the output ports of current actor.
                Iterator successors = embeddedActor.outputPortList().iterator();
                
                while (successors.hasNext()) {
                    IOPort outPort = (IOPort) successors.next();
    
                    List connectedPortList = outPort.connectedPortList();
                    outputs = connectedPortList.iterator();
                    while(outputs.hasNext()){
                        IOPort ioPort = (IOPort) outputs.next();
                        temp.addEdge(outPort, ioPort);
                    }
                }
            }
                            
            // Last, connect the container inputs to connected ports.
            inputs = actor.inputPortList().listIterator();
    
            while (inputs.hasNext()) {
                IOPort inputPort = (IOPort) inputs.next();
                List portList = inputPort.insidePortList();
                //System.out.println("PORTLIST" + portList);
                outputs = portList.iterator();
                while(outputs.hasNext()){
                    IOPort ioPort = (IOPort) outputs.next();
                    temp.addEdge(inputPort, ioPort);
                }
            }        
        
        } else if (actor instanceof AtomicActor) {
            //NOTE: This code is borrowed from FunctionDependency
            
            // For each input and output port pair, add a directed
            // edge going from the input port to the output port.
            inputs = actor.inputPortList().listIterator();
            while (inputs.hasNext()) {
                IOPort inputPort = (IOPort) inputs.next();
                outputs = actor.outputPortList().listIterator();
    
                while (outputs.hasNext()) {
                    // add an edge from the input port to the output port
                    temp.addEdge(inputPort, outputs.next());
                }
            }
            //End of code borrowed from FunctionDependency
        } else {
            System.out.println("unknown entity: " + actor);
        }
        
        return temp;
    }  
}