
/** CreateContourImage given a set of weather data creates the contour
 * plots using gnuplot image manipulation tool.            
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package util;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.*;
import ptolemy.data.Token;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.expr.*;
import ptolemy.data.*;
import ptolemy.data.AWTImageToken;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.*;
import java.util.*;
import java.util.HashMap;
import java.lang.*;
import org.ROADnet.ImageCreator;
import java.awt.*;



//////////////////////////////////////////////////////////////////////////
//// Contour Plotter
/**
   Using gnuplot create contour plot from given weather data and save the 
   image.

   @author Nandita Mangal, Application Based on Todd Hansen's ROADNet
   Application
   @version $Id: ContourPlotter.java,v 1.1 2005/09/27 10:47:17 
   @category.name ImageManipulation
 */


public class ContourPlotter extends TypedAtomicActor {
    /**
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public ContourPlotter(CompositeEntity container, String name)
	throws NameDuplicationException, IllegalActionException {
	
	super(container, name);

        //enter input data 
	input =new TypedIOPort(this,"input",true,false);
	input.setMultiport(false);
	input.setTypeEquals(BaseType.DOUBLE);

	//output the contour image.
	output = new TypedIOPort(this, "output", false, true);
	output.setMultiport(false);
	output.setTypeEquals(BaseType.STRING);  

	xRange = new StringParameter(this,"XRange");
	yRange = new StringParameter(this,"YRange");
       

    }
    ///////////////////////////////////////////////////////////////////
    ///               public methods                             ////
    
     /** Start up a new gnuplot process and feed commands into 
      * the sub process via its
      *  its input Stream. 
      *  Create contour plots based on those input data and x,yrange.
      *  
      *  @exception IllegalActionException
      */

    public void fire()  throws IllegalActionException
    {
	try{

	Process p=null;
	//start gnuplot
	//Process p = Runtime.getRuntime().exec("C:/gnuplot/gnuplot4/bin/pgnuplot.exe");
	//OutputStream outputStream = p.getOutputStream();
	//PrintWriter printWriter=outputStream!=null?new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream))):null;
	PrintWriter printWriter=null;
	//NOTE:- Temporary changes currently in affect due to transistion from ORB to SRB as 
	//well as changing currently implemented ORB source actors in Kepler.
	// cont_hum.dat is currently the source of data for humidity weather data.
	// cont_temp.dat is currently the source of data for temperature weather data.
	
	if(printWriter!=null)
          { 
		     
		     printWriter.println("reset\n");
		     printWriter.flush();
		     printWriter.println("set contour\n");
		     printWriter.flush();
		     printWriter.println("unset clabel");
		     printWriter.flush();
		     printWriter.println("unset surface\n");
		     printWriter.flush();
		     printWriter.println("set cntrparam levels inc 0,2,50\n");
		     printWriter.flush();
		     printWriter.println("set dgrid3d 50,50,10\n");
		     printWriter.flush();
		     printWriter.println("set view 140,91,1,1");
		     printWriter.flush();
		     printWriter.println("unset xzeroaxis");
		     printWriter.flush();
		     printWriter.println("unset yzeroaxis");
		     printWriter.flush();
		     printWriter.println("set xrange[32.4:33.6]");
		     printWriter.flush();
		     printWriter.println("set yrange[-118.4:-116.4]");
		     printWriter.flush();
		     printWriter.println("set term png transparent");
		     printWriter.flush();
		     printWriter.println("set output \"temp_hum.png\"");
		     printWriter.flush();
		     printWriter.println("set multiplot");
		     printWriter.flush();
		     printWriter.println("splot \"cont_temp.dat\" with lines lt 1 lw 1.5");
		     printWriter.flush();
		     printWriter.println("splot \"cont_hum.dat\" with lines lt 3 lw 1.5");
		     printWriter.flush();				 			 
		     printWriter.println("unset multiplot");
		     printWriter.flush();
		     printWriter.println("set output \"temp.png\"");
		     printWriter.flush();
		     printWriter.println("splot \"cont_temp.dat\" with lines lt 1 lw 1.5");
		     printWriter.flush();
		     printWriter.println("set output \"hum.png\"");
		     printWriter.flush();
		     printWriter.println("splot \"cont_hum.dat\" with lines lt 3 lw 1.5");
		     printWriter.flush();
		     printWriter.println("unset multiplot");
		     printWriter.flush();
		     printWriter.println("exit");
		     printWriter.flush();		     
			     			     
	 }
	
	 Image img=null;
	 String imgFileName ="";
	 
	 //destroy gnuplot process after plot is saved.
	 p.destroy();
		 
			
	  while(!((new File(imgFileName)).exists()))
	      {
		  //wait till file becomes available from gnuplot 
	      }
	  if( (new File(imgFileName)).exists())
	      {
	           //Save created plots on hard disk ,to be uploaded to server.
                   //ImageIO.write(img,"C:\Project\kepler";"PNG");
		   output.broadcast(new StringToken("http://www.angelfire.com/sd2/nmangal/abc.html"));
                   
		      
	      }
	}catch(Exception e) { System.err.println(e.toString()); }

    }

    ////////////////////////////////////////////////////////////////
    /////              public ports                          //////
   
    /* output image of gnuplot*/
    public TypedIOPort output;
    
    /* input data */
    public TypedIOPort input;
    public StringParameter xRange;
    public StringParameter yRange;
    
  
   
}
