/** ImageViewerJAI is an image viewer for viewing the JAI Planar images 
 * as well as AWTImages.
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package util;


import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.data.type.BaseType;
import ptolemy.data.ObjectToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.AWTImageToken;
import ptolemy.data.BooleanToken;


import java.io.*;
import java.util.*;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.awt.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;
import javax.swing.*;
import java.io.File;
import java.lang.Integer;
import javax.imageio.ImageIO;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.BorderLayout;
import java.awt.image.renderable.ParameterBlock;


import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.widget.ScrollingImagePanel;

/**
 * ImageViewer can be used to view images of type JAI/
 * advanced tiled JAI images.
 *
 @author Nandita Mangal
 @version $Id: ImageViewerJAI.java,v 1.1 2005/11/02 00:21:52 
 @category.name Image Manipulation
 */
public class ImageViewerJAI extends TypedAtomicActor
{
   ///////////////////////////////////////////////////////////////////////
    ////                   Parameters and Ports                       ////

    /*
     * The input image to be viewed.
     */
     public TypedIOPort imgSrc;

     /*
     * To save the output file or not
     */   
     public Parameter saveOutputFile;

     /*
     * If file is supposed to be saved,specify the location
     */
     public StringParameter outputFileLocation;  


  /**
   * constructor for ImageViewerJAI of the given container & name
   *
   *@param  container                     The container.
   *@param  name                          The name of this actor.
   *@exception  IllegalActionException    If the actor cannot be contained
   *   by the proposed container.
   *@exception  NameDuplicationException  If the container already has an
   *   actor with this name.
   */
  public ImageViewerJAI(CompositeEntity container, String name)
    throws
      NameDuplicationException, IllegalActionException
  {
    super(container, name);

         imgSrc = new TypedIOPort(this, "Source Image", true, false);  
	 imgSrc.setTypeEquals(BaseType.OBJECT);
         imgSrc.setMultiport(false);

         
         saveOutputFile = new Parameter( this,"Save Ouput Image?", new BooleanToken(true));    
         saveOutputFile.setTypeEquals(BaseType.BOOLEAN);

         outputFileLocation = new StringParameter(this,"Output Image Location:");
         outputFileLocation.setExpression(new String(System.getProperty("KEPLER") + "\\ImageResult.png"));
	
  }


   /////////////////////////////////////////////////////////////////
   ////                   public methods                       ////

  /**
   *
   *@exception  IllegalActionException  If there is no director.
   */
  public void fire()
    throws IllegalActionException
  {
    super.fire();

    Image logo =null;
    boolean fileSave = ( (BooleanToken) saveOutputFile.getToken()).booleanValue();		
    try{
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    logo = toolkit.getImage(new URL("http://roadnet.ucsd.edu/images/kepler-logo.jpg")); 
     	 
  }catch(Exception e) { e.toString(); }	

    output = imgSrc.get(0);
       
    if(output instanceof ObjectToken)
	{
		
		if(((ObjectToken)output).getValue() instanceof PlanarImage)
		{	

			 PlanarImage outputImage = (PlanarImage)((ObjectToken)output).getValue();	
			 JFrame f = new JFrame();
   			 f.setTitle("JAI Image Viewer");
   			 f.setIconImage(logo);
   			 f.getContentPane().add(new ScrollingImagePanel(outputImage, outputImage.getWidth(),outputImage.getHeight()));
 			 f.pack();
  			 f.show();	


			 if(fileSave == true)
    			{
				String location= outputFileLocation.stringValue();
				if (!(location.equals("")))
					JAI.create("filestore",outputImage,location,"PNG");
	
    			}


		}

	}
    else if(output instanceof AWTImageToken)
    {
		
		if(((AWTImageToken)output).getValue() instanceof Image || ((AWTImageToken)output).getValue() instanceof BufferedImage)
		{
			ImageIcon icon = new ImageIcon(((AWTImageToken)output).getValue());
			 JFrame f = new JFrame();
   			 f.setTitle("Image Viewer");
   			 f.setIconImage(logo);
   			 f.getContentPane().add(new JLabel(icon));
 			 f.pack();
  			 f.show();		
			if(fileSave == true)
  			  {
				String location= outputFileLocation.stringValue();
				if(!(location.equals("")))
                        {
					File file = new File(location);
					try{
					ImageIO.write((RenderedImage)((AWTImageToken)output).getValue(),"png",file);
					}catch(Exception e){e.toString();}
				}
   			  }
		}
	


   }
   
   
    
    
  }

  /**
   * Post fire the actor. Return false to indicate that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   *
   *@return
   */
  public boolean postfire()
  {
    return false;
  }

  /**
   * Pre fire the actor.
   *  Calls the super class's prefire in case something is set there.
   *
   *@return
   *@exception  IllegalActionException
   */
  public boolean prefire()
    throws IllegalActionException
  {
    return super.prefire();
  }

  

  ///////////////////////////////////////////////////////////////////
  ///                   private methods                         ////

  private Object output;

}

 