/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.metacat.authenticatedqueryservice.impl;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EcogridQueryToMetacatQueryTransformer {
    public static final String XSLT_FILENAME = "/xsd/xslt/ecogridToPathquery.xsl";
    private static Logger log = Logger.getLogger((Class)EcogridQueryToMetacatQueryTransformer.class);

    public static Reader ecogrid2Metacat(Reader reader) {
        Node node = EcogridQueryToMetacatQueryTransformer.parseXML(reader);
        log.info((Object)"parsed the ecogrid query xml");
        Reader reader2 = EcogridQueryToMetacatQueryTransformer.transformXML(node);
        log.info((Object)"transformed the ecogrid query xml to pathquery xml");
        return reader2;
    }

    public static Reader ecogrid2Metacat(String string) {
        StringReader stringReader = new StringReader(string);
        return EcogridQueryToMetacatQueryTransformer.ecogrid2Metacat(stringReader);
    }

    private static Node parseXML(Reader reader) {
        Node node = null;
        try {
            InputSource inputSource = new InputSource(reader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"/query");
            node = nodeList.item(0);
        }
        catch (Exception exception) {
            log.error((Object)"could not parse xml document");
        }
        return node;
    }

    private static Reader transformXML(Node node) {
        log.info((Object)("transforming xml node..." + node));
        StringReader stringReader = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(EcogridQueryToMetacatQueryTransformer.class.getResourceAsStream(XSLT_FILENAME)));
            log.info((Object)("transformer is: " + transformer));
            DOMSource dOMSource = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            log.info((Object)("query: " + stringWriter.toString()));
            stringReader = new StringReader(stringWriter.toString());
        }
        catch (Exception exception) {
            log.error((Object)"could not transform xml node");
            exception.printStackTrace();
        }
        return stringReader;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: java  EcogridQueryToMetacatQueryTransformer <input_filename> [outputfile]");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = null;
        if (stringArray.length == 2) {
            string2 = stringArray[1];
        }
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            EcogridQueryToMetacatQueryTransformer.ecogrid2Metacat(fileReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

