/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.metacat.impl;

import edu.ucsb.nceas.metacat.QueryGroup;
import edu.ucsb.nceas.metacat.QuerySpecification;
import edu.ucsb.nceas.metacat.QueryTerm;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.metacat.impl.MetacatImpl;
import org.ecoinformatics.ecogrid.queryservice.query.ANDType;
import org.ecoinformatics.ecogrid.queryservice.query.ConditionType;
import org.ecoinformatics.ecogrid.queryservice.query.ORType;
import org.ecoinformatics.ecogrid.queryservice.query.OperatorType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;

public class EcogridJavaToMetacatJavaQueryTransformer {
    public static final String INTERSECT = "INTERSECT";
    public static final String UNION = "UNION";
    public static final String ALLPATH = "/";
    private Hashtable operatorNameMatch = null;
    private static Logger logMetacat = Logger.getLogger((Class)MetacatImpl.class);

    public EcogridJavaToMetacatJavaQueryTransformer() {
        this.setupOperatorMatchTable();
    }

    public QuerySpecification transform(QueryType queryType) throws Exception {
        logMetacat.warn((Object)"in the begin of transform");
        QuerySpecification querySpecification = null;
        if (queryType == null) {
            return querySpecification;
        }
        querySpecification = new QuerySpecification(PropertyService.getProperty((String)"document.accNumSeparator"));
        logMetacat.warn((Object)"after instantial a metacat queryspecification");
        String string = queryType.getQueryId();
        logMetacat.warn((Object)("query id: " + string));
        querySpecification.setIdentifier(string);
        String[] stringArray = queryType.getTitle();
        String string2 = stringArray[0];
        logMetacat.warn((Object)("query title - " + string2));
        querySpecification.setQueryTitle(string2);
        Vector vector = this.namespaceToDocList(queryType.getNamespace());
        querySpecification.setReturnDocList(vector);
        this.transferReturnField(queryType, querySpecification);
        this.transferQueryGroup(queryType, querySpecification);
        logMetacat.warn((Object)("The metacat query toString is: " + querySpecification.toString()));
        logMetacat.warn((Object)"in the end of transform");
        return querySpecification;
    }

    private Vector namespaceToDocList(QueryTypeNamespace[] queryTypeNamespaceArray) {
        logMetacat.warn((Object)"start of namespaceToDocList()");
        Vector<String> vector = new Vector<String>();
        if (queryTypeNamespaceArray == null || queryTypeNamespaceArray.length == 0) {
            return vector;
        }
        for (int i = 0; i < queryTypeNamespaceArray.length; ++i) {
            QueryTypeNamespace queryTypeNamespace = queryTypeNamespaceArray[i];
            String string = queryTypeNamespace.get_value();
            logMetacat.warn((Object)("the return doc list(namespace) is " + string));
            vector.add(string);
        }
        logMetacat.warn((Object)"end of namespaceToDocList()");
        return vector;
    }

    private void transferReturnField(QueryType queryType, QuerySpecification querySpecification) {
        logMetacat.warn((Object)"start of transferReturnField");
        String[] stringArray = queryType.getReturnField();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                logMetacat.warn((Object)("returnField is " + string));
                querySpecification.handleReturnField(string);
            }
        }
        logMetacat.warn((Object)"end of transferReturnField");
    }

    private void transferQueryGroup(QueryType queryType, QuerySpecification querySpecification) throws Exception {
        logMetacat.warn((Object)"start of transferQueryGroup()");
        QueryGroup queryGroup = null;
        if (queryType.getAND() != null) {
            logMetacat.warn((Object)"first level is AND");
            queryGroup = new QueryGroup(INTERSECT);
            this.handleANDChildren(queryGroup, queryType.getAND());
        } else if (queryType.getOR() != null) {
            logMetacat.warn((Object)"first level is OR");
            queryGroup = new QueryGroup(UNION);
            this.handleORChildren(queryGroup, queryType.getOR());
        } else if (queryType.getCondition() != null) {
            logMetacat.warn((Object)"first level is Condition");
            queryGroup = new QueryGroup(INTERSECT);
            this.handleConditionType(queryGroup, queryType.getCondition());
        } else {
            logMetacat.warn((Object)"Wrong format of query");
            throw new Exception("Wrong Ecogrid Query Format");
        }
        querySpecification.setQueryGroup(queryGroup);
        logMetacat.warn((Object)"end of transferQueryGroup()");
    }

    private void handleANDChildren(QueryGroup queryGroup, ANDType aNDType) {
        int n;
        logMetacat.warn((Object)"start of handleANDChildren()(parent is AND)");
        if (queryGroup == null || aNDType == null) {
            logMetacat.warn((Object)"query group is null or andparent is null");
            return;
        }
        if (aNDType.getAND() != null) {
            for (n = 0; n < aNDType.getAND().length; ++n) {
                logMetacat.warn((Object)"add AND childen to parent AND");
                this.handleANDType(queryGroup, aNDType.getAND(n));
            }
        }
        if (aNDType.getOR() != null) {
            for (n = 0; n < aNDType.getOR().length; ++n) {
                logMetacat.warn((Object)"add OR childen to parent AND");
                this.handleORType(queryGroup, aNDType.getOR(n));
            }
        }
        if (aNDType.getCondition() != null) {
            for (n = 0; n < aNDType.getCondition().length; ++n) {
                logMetacat.warn((Object)"add Condition childen to parent AND");
                this.handleConditionType(queryGroup, aNDType.getCondition(n));
            }
        }
        logMetacat.warn((Object)"end of handleANDChildren()(parent is AND)");
    }

    private void handleORChildren(QueryGroup queryGroup, ORType oRType) {
        int n;
        logMetacat.warn((Object)"start of handleORChildren()(parent is OR)");
        if (queryGroup == null || oRType == null) {
            return;
        }
        if (oRType.getAND() != null) {
            for (n = 0; n < oRType.getAND().length; ++n) {
                logMetacat.warn((Object)"add AND childen to parent OR");
                this.handleANDType(queryGroup, oRType.getAND(n));
            }
        }
        if (oRType.getOR() != null) {
            for (n = 0; n < oRType.getOR().length; ++n) {
                logMetacat.warn((Object)"add OR childen to parent OR");
                this.handleORType(queryGroup, oRType.getOR(n));
            }
        }
        if (oRType.getCondition() != null) {
            for (n = 0; n < oRType.getCondition().length; ++n) {
                logMetacat.warn((Object)"add Condtion childen to parent OR");
                this.handleConditionType(queryGroup, oRType.getCondition(n));
            }
        }
        logMetacat.warn((Object)"end of handleORChildren()(parent is OR)");
    }

    private void handleANDType(QueryGroup queryGroup, ANDType aNDType) {
        logMetacat.warn((Object)"start handleANDType()");
        if (queryGroup == null || aNDType == null) {
            return;
        }
        QueryGroup queryGroup2 = new QueryGroup(INTERSECT);
        queryGroup.addChild(queryGroup2);
        this.handleANDChildren(queryGroup2, aNDType);
        logMetacat.warn((Object)"end handleANDType()");
    }

    private void handleORType(QueryGroup queryGroup, ORType oRType) {
        logMetacat.warn((Object)"start handleORType()");
        if (queryGroup == null || oRType == null) {
            return;
        }
        QueryGroup queryGroup2 = new QueryGroup(UNION);
        queryGroup.addChild(queryGroup2);
        this.handleORChildren(queryGroup2, oRType);
        logMetacat.warn((Object)"end handleORType()");
    }

    private void handleConditionType(QueryGroup queryGroup, ConditionType conditionType) {
        logMetacat.warn((Object)"start of handleConditionType()");
        QueryTerm queryTerm = null;
        if (queryGroup == null || conditionType == null) {
            return;
        }
        String string = conditionType.getConcept();
        logMetacat.warn((Object)("path express is " + string));
        if (string != null && string.equals(ALLPATH)) {
            string = null;
            logMetacat.warn((Object)"ALLPATH string was replaced by null");
        }
        OperatorType operatorType = conditionType.getOperator();
        String string2 = operatorType.getValue();
        String string3 = this.lookupMetacatOperator(string2);
        String string4 = conditionType.get_value();
        logMetacat.warn((Object)("value for path is " + string4));
        queryTerm = new QueryTerm(false, string3, string4, string);
        queryGroup.addChild(queryTerm);
        logMetacat.warn((Object)"end of handleConditionType()");
    }

    private String lookupMetacatOperator(String string) {
        logMetacat.warn((Object)("operator in ecogrid(input) is " + string));
        String string2 = null;
        string2 = (String)this.operatorNameMatch.get(string);
        logMetacat.warn((Object)("operator in metacat(output) is " + string2));
        return string2;
    }

    private void setupOperatorMatchTable() {
        this.operatorNameMatch = new Hashtable();
        this.operatorNameMatch.put("LIKE", "contains");
        this.operatorNameMatch.put("NOT LIKE", "not-contains");
        this.operatorNameMatch.put("EQUALS", "equals");
        this.operatorNameMatch.put("NOT EQUALS", "isnot-equal");
        this.operatorNameMatch.put("LESS THAN", "less-than");
        this.operatorNameMatch.put("LESS THAN OR EQUALS", "less-than-equals");
        this.operatorNameMatch.put("GREATER THAN", "greater-than");
        this.operatorNameMatch.put("GREATER THAN OR EQUALS", "greater-than-equals");
    }
}

