/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.queryservice.util;

import java.io.StringReader;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.queryservice.query.ANDType;
import org.ecoinformatics.ecogrid.queryservice.query.ConditionType;
import org.ecoinformatics.ecogrid.queryservice.query.ORType;
import org.ecoinformatics.ecogrid.queryservice.query.OperatorType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryParser;

public class EcogridQueryTransformer {
    private static boolean mIdent = true;

    public static void setIndent(boolean bl) {
        mIdent = bl;
    }

    private static String getLeadingSpace(int n) {
        if (!mIdent) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    private static void process(StringBuffer stringBuffer, ANDType[] aNDTypeArray, ORType[] oRTypeArray, ConditionType[] conditionTypeArray, int n) {
        int n2;
        if (aNDTypeArray != null) {
            for (n2 = 0; n2 < aNDTypeArray.length; ++n2) {
                EcogridQueryTransformer.processAND(stringBuffer, aNDTypeArray[n2], n + 1);
            }
        }
        if (oRTypeArray != null) {
            for (n2 = 0; n2 < oRTypeArray.length; ++n2) {
                EcogridQueryTransformer.processOR(stringBuffer, oRTypeArray[n2], n + 1);
            }
        }
        if (conditionTypeArray != null) {
            for (n2 = 0; n2 < conditionTypeArray.length; ++n2) {
                EcogridQueryTransformer.processCond(stringBuffer, conditionTypeArray[n2], n + 1);
            }
        }
    }

    private static void processAND(StringBuffer stringBuffer, ANDType aNDType, int n) {
        if (aNDType == null) {
            return;
        }
        stringBuffer.append(EcogridQueryTransformer.getLeadingSpace(n));
        stringBuffer.append("<AND>\n");
        EcogridQueryTransformer.process(stringBuffer, aNDType.getAND(), aNDType.getOR(), aNDType.getCondition(), n);
        stringBuffer.append(EcogridQueryTransformer.getLeadingSpace(n));
        stringBuffer.append("</AND>\n");
    }

    private static void processOR(StringBuffer stringBuffer, ORType oRType, int n) {
        if (oRType == null) {
            return;
        }
        stringBuffer.append(EcogridQueryTransformer.getLeadingSpace(n));
        stringBuffer.append("<OR>\n");
        EcogridQueryTransformer.process(stringBuffer, oRType.getAND(), oRType.getOR(), oRType.getCondition(), n);
        stringBuffer.append(EcogridQueryTransformer.getLeadingSpace(n));
        stringBuffer.append("</OR>\n");
    }

    private static void processCond(StringBuffer stringBuffer, ConditionType conditionType, int n) {
        String string;
        if (conditionType == null) {
            return;
        }
        stringBuffer.append(EcogridQueryTransformer.getLeadingSpace(n));
        stringBuffer.append("<condition");
        OperatorType operatorType = conditionType.getOperator();
        if (operatorType != null) {
            stringBuffer.append(" operator=\"" + operatorType.getValue() + "\"");
        }
        if ((string = conditionType.getConcept()) != null) {
            stringBuffer.append(" concept=\"" + string + "\"");
        }
        stringBuffer.append(">" + conditionType + "</condition>\n");
    }

    public static String toXMLString(QueryType queryType) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("<query");
        if (queryType.getQueryId() != null) {
            stringBuffer.append(" queryId=\"" + queryType.getQueryId() + "\"");
        }
        if (queryType.getSystem() != null) {
            stringBuffer.append(" system=\"" + queryType.getSystem().toString() + "\"");
        }
        stringBuffer.append(">\n");
        QueryTypeNamespace[] queryTypeNamespaceArray = queryType.getNamespace();
        for (int i = 0; i < queryTypeNamespaceArray.length; ++i) {
            QueryTypeNamespace queryTypeNamespace = queryTypeNamespaceArray[i];
            if (queryTypeNamespace == null) continue;
            stringBuffer.append("  <namespace");
            if (queryTypeNamespace.getPrefix() != null) {
                stringBuffer.append(" prefix=\"" + queryTypeNamespace.getPrefix() + "\"");
            }
            stringBuffer.append(">" + queryTypeNamespace.get_value().toString() + "</namespace>\n");
        }
        String[] stringArray2 = queryType.getReturnField();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append("  <returnField>" + stringArray2[i] + "</returnField>\n");
            }
        }
        if ((stringArray = queryType.getTitle()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("  <title>" + stringArray[i] + "</title>\n");
            }
        }
        EcogridQueryTransformer.processAND(stringBuffer, queryType.getAND(), 1);
        EcogridQueryTransformer.processOR(stringBuffer, queryType.getOR(), 1);
        EcogridQueryTransformer.processCond(stringBuffer, queryType.getCondition(), 1);
        stringBuffer.append("</query>");
        return stringBuffer.toString();
    }

    public static void test(String string) {
        QueryType queryType = null;
        String string2 = EcogridUtils.readXMLFile2Str(string);
        StringReader stringReader = new StringReader(string2);
        try {
            EcogridQueryParser ecogridQueryParser = new EcogridQueryParser(stringReader);
            ecogridQueryParser.parseXML();
            queryType = ecogridQueryParser.getEcogridQuery();
            System.out.println("File contains:");
            System.out.println(string2);
            System.out.println("Query XML:");
            System.out.println(EcogridQueryTransformer.toXMLString(queryType));
            System.out.println("\n");
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        EcogridQueryTransformer.test("/home/globus/workspace/kepler/query.xml");
        EcogridQueryTransformer.test("/home/globus/seek/projects/ecogrid/tests/testfiles/query-digir.xml");
        EcogridQueryTransformer.test("/home/globus/seek/projects/ecogrid/tests/testfiles/query-test.xml");
    }
}

