<?xml version="1.0"?>
<!--
  *  '$RCSfile: metacatToEcogridResultSet.xsl,v $'
  *      Authors: Matt Jones
  *    Copyright: 2000 Regents of the University of California and the
  *               National Center for Ecological Analysis and Synthesis
  *  For Details: http://www.nceas.ucsb.edu/
  *
  *   '$Author: tao $'
  *     '$Date: 2003-09-14 00:00:59 $'
  * '$Revision: 1.1 $'
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  *
  * This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
  * convert an eco grid query XML file to metacat path query XML file
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" encoding="utf-8"/>
   <xsl:template match="/">
     <xsl:param name="numOfRecord" select="count(resultset/document)"/>
     <resultset resultsetId="eml.001.1" system="knb">
        <resultsetMetadata>
            <sendTime>unkown</sendTime>
            <recordCount><xsl:value-of select="$numOfRecord"/></recordCount>
        </resultsetMetadata>
        <records startRecord="1" endRecord="{$numOfRecord}">
          <xsl:call-template name="createRecord"/>
        </records>
     </resultset> 
   </xsl:template>
   
   <xsl:template name="createRecord">
     <xsl:for-each select="resultset/document">
       <xsl:variable name="num" select="position()"/>
       <xsl:variable name="identifier" select="./docid"/>
       <record number="{$num}" identifier="{$identifier}">
         <xsl:copy-of select="."/>
       </record>
     </xsl:for-each>
   </xsl:template>
 
 </xsl:stylesheet>
