/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;

public class CopyTest {
    static final String checksum = "md5sum";
    GeneralFile source;
    GeneralFile remoteDestination;
    GeneralFile returnDestination;

    public CopyTest(GeneralFile generalFile, GeneralFile generalFile2) throws IOException {
        if (generalFile.mkdir()) {
            GeneralRandomAccessFile generalRandomAccessFile = null;
            double d = 0.0;
            while (d < 5015.0) {
                generalRandomAccessFile = FileFactory.newRandomAccessFile(FileFactory.newFile(generalFile, "f" + d), "rw");
                generalRandomAccessFile.write(d + "\n");
                generalRandomAccessFile.write(new byte[(int)d]);
                generalRandomAccessFile.write(d + "\n");
                generalRandomAccessFile.write(new byte[(int)d]);
                generalRandomAccessFile.write(d + "\n");
                generalRandomAccessFile.close();
                d += 1.0;
            }
            generalRandomAccessFile = FileFactory.newRandomAccessFile(FileFactory.newFile(generalFile, "fbig1"), "rw");
            int n = 0;
            while (n < 10) {
                generalRandomAccessFile.write(n + " ");
                generalRandomAccessFile.write(new byte[1000000]);
                ++n;
            }
            generalRandomAccessFile.close();
            generalRandomAccessFile = FileFactory.newRandomAccessFile(FileFactory.newFile(generalFile, "fbig2"), "rw");
            int n2 = 0;
            while (n2 < 65) {
                generalRandomAccessFile.write(n2 + " ");
                generalRandomAccessFile.write(new byte[1000000]);
                ++n2;
            }
            generalRandomAccessFile.close();
        }
        this.source = generalFile;
        this.remoteDestination = generalFile2;
    }

    public void copy() throws IOException {
        double d = new Date().getTime();
        System.out.println("srb: " + this.remoteDestination + " time: " + d);
        this.remoteDestination.copyFrom(this.source);
        System.out.println("upload time: " + ((double)new Date().getTime() - d));
        this.returnDestination = FileFactory.newFile(this.source, "download");
        this.returnDestination.copyFrom(this.remoteDestination);
        System.out.println("localFile: " + this.returnDestination);
        System.out.println("total copy time: " + ((double)new Date().getTime() - d));
    }

    public boolean compare() throws IOException {
        return this.compare(false);
    }

    public boolean compare(boolean bl) throws IOException {
        String string = null;
        String string2 = null;
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        byte[] byArray = new byte[33];
        boolean bl2 = false;
        GeneralFile generalFile = null;
        if (bl) {
            if (!this.remoteDestination.exists()) {
                return false;
            }
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.remoteDestination.getAbsolutePath())};
            String[] stringArray = new String[]{"file name", "path name", "size"};
            MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(stringArray);
            MetaDataRecordList[] metaDataRecordListArray = ((SRBFileSystem)this.remoteDestination.getFileSystem()).query(metaDataConditionArray, metaDataSelectArray);
            metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            int n = 0;
            while (n < metaDataRecordListArray.length) {
                if (metaDataRecordListArray[n].getIntValue(2) > 0) {
                    inputStream2 = ((SRBFileSystem)this.remoteDestination.getFileSystem()).executeProxyCommand(checksum, metaDataRecordListArray[n].getValue("path name").toString());
                    int n2 = inputStream2.read();
                    while (n2 != -1) {
                        string = string + "" + (char)n2;
                        n2 = inputStream2.read();
                    }
                    string = string + "" + (char)n2;
                    inputStream2.close();
                    generalFile = FileFactory.newFile(this.source, metaDataRecordListArray[n].getValue("file name").toString());
                    process = Runtime.getRuntime().exec("md5sum " + generalFile.getAbsolutePath());
                    inputStream = process.getInputStream();
                    inputStream.read(byArray);
                    string2 = new String(byArray);
                    inputStream.close();
                    if (string.indexOf(string2) < 0) {
                        System.out.println("error " + generalFile);
                        bl2 = true;
                    }
                    string = "";
                }
                System.out.print(n + " ");
                ++n;
            }
        } else {
            if (!this.returnDestination.exists()) {
                return false;
            }
            String[] stringArray = this.source.list();
            int n = 0;
            while (n < stringArray.length) {
                generalFile = FileFactory.newFile(this.source, stringArray[n]);
                if (!generalFile.isDirectory()) {
                    process = Runtime.getRuntime().exec("md5sum " + generalFile.getAbsolutePath());
                    inputStream = process.getInputStream();
                    inputStream.read(byArray);
                    string2 = new String(byArray);
                    generalFile = FileFactory.newFile(this.returnDestination, generalFile.getName());
                    process = Runtime.getRuntime().exec("md5sum " + generalFile.getAbsolutePath());
                    inputStream = process.getInputStream();
                    inputStream.read(byArray);
                    string = new String(byArray);
                    inputStream.close();
                    if (!string.equals(string2)) {
                        System.out.println("error " + generalFile);
                        bl2 = true;
                    }
                }
                ++n;
            }
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            String string = "file:/scratch/slocal/iktome/sourcedata";
            String string2 = "mySRBCopyTest";
            LocalFile localFile = null;
            SRBFile sRBFile = null;
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            try {
                localFile = new LocalFile(new URI(string));
                if (localFile.createNewFile()) {
                    localFile.delete();
                }
            }
            catch (Throwable throwable) {
                localFile = new LocalFile(string2);
            }
            if (stringArray.length > 1) {
                sRBFile = new SRBFile(new URI(stringArray[1]));
            } else {
                object = new SRBFileSystem();
                int n = 0;
                do {
                    sRBFile = new SRBFile((SRBFileSystem)object, "copyTest" + n);
                    ++n;
                } while (sRBFile.exists());
            }
            object = new CopyTest(localFile, sRBFile);
            ((CopyTest)object).copy();
            ((CopyTest)object).compare();
        }
        catch (Throwable throwable) {
            System.out.println("\nJava Error Message: " + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

