/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileOutputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.local.LocalAccount;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalFileInputStream;
import edu.sdsc.grid.io.local.LocalFileOutputStream;
import edu.sdsc.grid.io.local.LocalFileSystem;
import edu.sdsc.grid.io.local.LocalMetaDataRecordList;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileInputStream;
import edu.sdsc.grid.io.srb.SRBFileOutputStream;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class FileFactory {
    static GeneralAccount newAccount(URI uRI) {
        if (uRI != null && uRI.getScheme().equals("srb")) {
            String string = uRI.getHost();
            int n = uRI.getPort();
            String string2 = uRI.getPath();
            String string3 = uRI.getUserInfo();
            Object var5_5 = null;
            Object var6_6 = null;
            Object var7_7 = null;
            Object var8_8 = null;
        }
        return new LocalAccount();
    }

    static GeneralAccount newAccount(URI uRI, String string) {
        if (uRI != null) {
            int n = -1;
            String string2 = uRI.getUserInfo();
            if (uRI.getScheme().equals("srb")) {
                if (string.indexOf(":") >= 0 || string.indexOf("@") >= 0) {
                    throw new IllegalArgumentException("Password contains illegal charaters");
                }
                n = string2.indexOf(":");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                string2 = string2 + ":" + string;
                try {
                    uRI = new URI(uRI.getScheme(), string2, uRI.getHost(), uRI.getPort(), uRI.getPath(), "", "");
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Password contains illegal charaters");
                }
                return FileFactory.newAccount(uRI);
            }
        }
        return new LocalAccount();
    }

    static GeneralFile newAccount(URI uRI, String string, String string2) {
        int n = -1;
        String string3 = uRI.getUserInfo();
        if (uRI.getScheme().equals("srb")) {
            Object var5_5 = null;
        }
        return new LocalFile(uRI);
    }

    public static GeneralFileSystem newFileSystem(GeneralAccount generalAccount) throws IOException {
        if (generalAccount != null && generalAccount instanceof SRBAccount) {
            return new SRBFileSystem((SRBAccount)generalAccount);
        }
        return new LocalFileSystem();
    }

    public static GeneralFileSystem newFileSystem(URI uRI) throws IOException {
        if (uRI != null) {
            GeneralFile generalFile = FileFactory.newFile(uRI);
            return generalFile.getFileSystem();
        }
        return new LocalFileSystem();
    }

    public static GeneralFile newFile(URI uRI) throws IOException {
        if (uRI.getScheme().equals("srb")) {
            return new SRBFile(uRI);
        }
        return new LocalFile(uRI);
    }

    public static GeneralFile newFile(URI uRI, String string) throws IOException {
        int n = -1;
        String string2 = uRI.getUserInfo();
        if (uRI.getScheme().equals("srb")) {
            if (string.indexOf(":") >= 0 || string.indexOf("@") >= 0) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            n = string2.indexOf(":");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            string2 = string2 + ":" + string;
            try {
                uRI = new URI(uRI.getScheme(), string2, uRI.getHost(), uRI.getPort(), uRI.getPath(), "", "");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            return new SRBFile(uRI);
        }
        return new LocalFile(uRI);
    }

    static GeneralFile newFile(URI uRI, String string, String string2) throws IOException {
        int n = -1;
        String string3 = uRI.getUserInfo();
        if (uRI.getScheme().equals("srb")) {
            // empty if block
        }
        return new LocalFile(uRI);
    }

    public static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string) {
        if (generalFileSystem != null && generalFileSystem instanceof SRBFileSystem) {
            return new SRBFile((SRBFileSystem)generalFileSystem, string);
        }
        return new LocalFile(string);
    }

    public static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string, String string2) {
        if (generalFileSystem != null && generalFileSystem instanceof SRBFileSystem) {
            return new SRBFile((SRBFileSystem)generalFileSystem, string, string2);
        }
        return new LocalFile(string, string2);
    }

    public static GeneralFile newFile(GeneralFile generalFile, String string) {
        if (generalFile != null && generalFile instanceof SRBFile) {
            return new SRBFile((SRBFile)generalFile, string);
        }
        return new LocalFile((LocalFile)generalFile, string);
    }

    public static GeneralRandomAccessFile newRandomAccessFile(GeneralFile generalFile, String string) throws IOException {
        if (generalFile instanceof SRBFile) {
            return new SRBRandomAccessFile((SRBFile)generalFile, string);
        }
        return new LocalRandomAccessFile((LocalFile)generalFile, string);
    }

    public static GeneralRandomAccessFile newRandomAccessFile(URI uRI, String string) throws IOException {
        GeneralFile generalFile = FileFactory.newFile(uRI);
        if (generalFile instanceof SRBFile) {
            return new SRBRandomAccessFile((SRBFile)generalFile, string);
        }
        return new LocalRandomAccessFile((LocalFile)generalFile, string);
    }

    public static GeneralFileInputStream newFileInputStream(GeneralFile generalFile) throws IOException {
        if (generalFile instanceof SRBFile) {
            return new SRBFileInputStream((SRBFile)generalFile);
        }
        return new LocalFileInputStream((LocalFile)generalFile);
    }

    public static GeneralFileInputStream newFileInputStream(URI uRI) throws IOException {
        GeneralFile generalFile = FileFactory.newFile(uRI);
        if (generalFile instanceof SRBFile) {
            return new SRBFileInputStream((SRBFile)generalFile);
        }
        return new LocalFileInputStream((LocalFile)generalFile);
    }

    public static GeneralFileOutputStream newFileOutputStream(GeneralFile generalFile) throws IOException {
        if (generalFile instanceof SRBFile) {
            return new SRBFileOutputStream((SRBFile)generalFile);
        }
        return new LocalFileOutputStream((LocalFile)generalFile);
    }

    public static GeneralFileOutputStream newFileOutputStream(URI uRI) throws IOException {
        GeneralFile generalFile = FileFactory.newFile(uRI);
        if (generalFile instanceof SRBFile) {
            return new SRBFileOutputStream((SRBFile)generalFile);
        }
        return new LocalFileOutputStream((LocalFile)generalFile);
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, int n) {
        if (generalFileSystem instanceof SRBFileSystem) {
            return new SRBMetaDataRecordList(metaDataField, n);
        }
        return new LocalMetaDataRecordList();
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, float f) {
        if (generalFileSystem instanceof SRBFileSystem) {
            return new SRBMetaDataRecordList(metaDataField, f);
        }
        return new LocalMetaDataRecordList();
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, String string) {
        if (generalFileSystem instanceof SRBFileSystem) {
            return new SRBMetaDataRecordList(metaDataField, string);
        }
        return new LocalMetaDataRecordList();
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, MetaDataTable metaDataTable) {
        if (generalFileSystem instanceof SRBFileSystem) {
            return new SRBMetaDataRecordList(metaDataField, metaDataTable);
        }
        return new LocalMetaDataRecordList();
    }
}

