/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Vector;

public class GeneralFile
implements Comparable {
    public static final int BUFFER_MAX_SIZE = 65535;
    protected GeneralFileSystem fileSystem;
    protected Vector directory;
    protected String fileName;

    protected GeneralFile(GeneralFileSystem generalFileSystem, String string, String string2) throws NullPointerException {
        this.setFileSystem(generalFileSystem);
        this.setDirectory(string);
        this.setFileName(string2);
    }

    protected GeneralFile(URI uRI) throws NullPointerException, IllegalArgumentException {
    }

    protected void finalize() throws Throwable {
        if (this.fileSystem != null) {
            this.fileSystem = null;
        }
        if (this.directory != null) {
            this.directory = null;
        }
        if (this.fileName != null) {
            this.fileName = null;
        }
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = generalFileSystem;
    }

    protected void setDirectory(String string) {
        throw new UnsupportedOperationException();
    }

    protected void setFileName(String string) {
        throw new UnsupportedOperationException();
    }

    public String getPathSeparator() {
        throw new UnsupportedOperationException();
    }

    public char getPathSeparatorChar() {
        throw new UnsupportedOperationException();
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(String[] stringArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void modifyMetaData(MetaDataRecordList metaDataRecordList) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void copyTo(GeneralFile generalFile) throws IOException {
        this.copyTo(generalFile, false);
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        byte[] byArray = null;
        GeneralRandomAccessFile generalRandomAccessFile = null;
        GeneralRandomAccessFile generalRandomAccessFile2 = null;
        if (generalFile == null) {
            throw new NullPointerException();
        }
        if (this.isDirectory()) {
            GeneralFile[] generalFileArray = this.listFiles();
            generalFile.mkdir();
            if (generalFileArray != null) {
                int n = 0;
                while (n < generalFileArray.length) {
                    generalFileArray[n].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), generalFileArray[n].getName()), bl);
                    ++n;
                }
            }
        } else {
            if (generalFile.isDirectory()) {
                generalFile = FileFactory.newFile(generalFile, this.getName());
            }
            long l = this.length();
            generalRandomAccessFile = FileFactory.newRandomAccessFile(this, "r");
            generalRandomAccessFile2 = FileFactory.newRandomAccessFile(generalFile, "rw");
            if (bl) {
                try {
                    generalRandomAccessFile2.setLength(this.length());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    generalFile.delete();
                    generalRandomAccessFile2 = FileFactory.newRandomAccessFile(generalFile, "rw");
                }
            } else {
                generalRandomAccessFile2.seek(generalRandomAccessFile2.length());
            }
            if (l > 65535L) {
                byArray = new byte[65535];
                do {
                    generalRandomAccessFile.read(byArray);
                    generalRandomAccessFile2.write(byArray);
                } while ((l -= 65535L) > 65535L);
            }
            byArray = new byte[(int)l];
            generalRandomAccessFile.read(byArray);
            generalRandomAccessFile2.write(byArray);
            generalRandomAccessFile.close();
            generalRandomAccessFile2.close();
        }
    }

    public void copyFrom(GeneralFile generalFile) throws IOException {
        this.copyFrom(generalFile, false);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        byte[] byArray = null;
        GeneralRandomAccessFile generalRandomAccessFile = null;
        GeneralRandomAccessFile generalRandomAccessFile2 = null;
        if (generalFile == null) {
            throw new NullPointerException();
        }
        if (generalFile.isDirectory()) {
            GeneralFile[] generalFileArray = generalFile.listFiles();
            this.mkdir();
            if (generalFileArray != null) {
                int n = 0;
                while (n < generalFileArray.length) {
                    FileFactory.newFile(this, generalFileArray[n].getName()).copyFrom(generalFileArray[n], bl);
                    ++n;
                }
            }
        } else {
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile);
                return;
            }
            long l = generalFile.length();
            generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "r");
            generalRandomAccessFile2 = FileFactory.newRandomAccessFile(this, "rw");
            if (bl) {
                try {
                    generalRandomAccessFile2.setLength(this.length());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.delete();
                }
            } else {
                generalRandomAccessFile2.seek(generalRandomAccessFile2.length());
            }
            if (l > 65535L) {
                byArray = new byte[65535];
                do {
                    generalRandomAccessFile.read(byArray);
                    generalRandomAccessFile2.write(byArray);
                } while ((l -= 65535L) > 65535L);
            }
            byArray = new byte[(int)l];
            generalRandomAccessFile.read(byArray);
            generalRandomAccessFile2.write(byArray);
            generalRandomAccessFile.close();
            generalRandomAccessFile2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String checksum() throws IOException {
        long l;
        long l2;
        block8: {
            if (!this.isFile()) {
                return null;
            }
            l2 = 0L;
            l = 0L;
            GeneralFileInputStream generalFileInputStream = null;
            try {
                generalFileInputStream = FileFactory.newFileInputStream(this);
                int n = 0;
                byte[] byArray = new byte[65535];
                block2: while (true) {
                    if ((n = generalFileInputStream.read(byArray)) <= -1) {
                        Object var10_8 = null;
                        if (generalFileInputStream == null) break block8;
                        break;
                    }
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        l2 += (long)(byArray[n2] & 0xFF);
                        ++l;
                        ++n2;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (generalFileInputStream != null) {
                    generalFileInputStream.close();
                }
                throw throwable;
            }
            generalFileInputStream.close();
        }
        if (l - this.length() != 0L) {
            // empty if block
        }
        long l3 = (l2 & 0xFFFFL) + ((l2 & 0xFFFFFFFFFFFFFFFFL) >> 16 & 0xFFFFL);
        l2 = (l3 & 0xFFFFL) + (l3 >> 16);
        return "" + l2;
    }

    public boolean canRead() {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(GeneralFile generalFile) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object object) throws ClassCastException {
        throw new UnsupportedOperationException();
    }

    public boolean createNewFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static GeneralFile createTempFile(String string, String string2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public void deleteOnExit() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getAbsoluteFile() {
        throw new UnsupportedOperationException();
    }

    public String getAbsolutePath() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getCanonicalPath() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.fileName;
    }

    public String getParent() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getParentFile() {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public boolean isAbsolute() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectory() {
        throw new UnsupportedOperationException();
    }

    public boolean isFile() {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    public long length() {
        throw new UnsupportedOperationException();
    }

    public String[] list() {
        throw new UnsupportedOperationException();
    }

    public String[] list(MetaDataCondition[] metaDataConditionArray) {
        throw new UnsupportedOperationException();
    }

    public GeneralFile[] listFiles() {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        GeneralFile[] generalFileArray = new GeneralFile[n];
        int n2 = 0;
        while (n2 < n) {
            generalFileArray[n2] = FileFactory.newFile(this, stringArray[n2]);
            ++n2;
        }
        return generalFileArray;
    }

    public static GeneralFile[] listRoots() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs() {
        throw new UnsupportedOperationException();
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException, NullPointerException {
        throw new UnsupportedOperationException();
    }

    public boolean setLastModified(long l) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getPath();
    }

    public URI toURI() {
        throw new UnsupportedOperationException();
    }

    public URL toURL() throws MalformedURLException {
        throw new UnsupportedOperationException();
    }
}

