/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import java.io.IOException;
import java.io.OutputStream;

public abstract class GeneralFileOutputStream
extends OutputStream {
    protected int fd = -1;

    public GeneralFileOutputStream(GeneralFileSystem generalFileSystem, String string) throws IOException {
        this(FileFactory.newFile(generalFileSystem, string));
    }

    public GeneralFileOutputStream(GeneralFile generalFile) throws IOException {
        if (generalFile == null) {
            throw new NullPointerException("File cannot be null.");
        }
        if (!generalFile.exists()) {
            generalFile.createNewFile();
        }
        this.open(generalFile);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    protected abstract void open(GeneralFile var1) throws IOException;

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;
}

