/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFileInputStream;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;

public class SRBFileInputStream
extends RemoteFileInputStream {
    long filePointer = 0L;
    protected SRBFileSystem fileSystem;
    SRBFile file;

    public SRBFileInputStream(SRBFileSystem sRBFileSystem, String string) throws IOException {
        super(sRBFileSystem, string);
        this.fileSystem = sRBFileSystem;
    }

    public SRBFileInputStream(SRBFile sRBFile) throws IOException {
        super(sRBFile);
        this.fileSystem = (SRBFileSystem)sRBFile.getFileSystem();
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = (SRBFileSystem)generalFileSystem;
    }

    public GeneralFileSystem getFileSystem() {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException();
    }

    protected void open(GeneralFile generalFile) throws IOException {
        this.file = (SRBFile)generalFile;
        this.fd = ((SRBFileSystem)generalFile.getFileSystem()).srbObjOpen(generalFile.getName(), 0, generalFile.getParent());
    }

    public int read() throws IOException {
        block3: {
            try {
                byte[] byArray = this.fileSystem.srbObjRead(this.fd, 1);
                if (byArray != null) {
                    this.filePointer += (long)byArray.length;
                    return byArray[0];
                }
            }
            catch (SRBException sRBException) {
                if (sRBException.getType() == -1) break block3;
                throw sRBException;
            }
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        block3: {
            try {
                byte[] byArray2 = null;
                byArray2 = this.fileSystem.srbObjRead(this.fd, n2);
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    this.filePointer += (long)byArray2.length;
                    return byArray2.length;
                }
            }
            catch (SRBException sRBException) {
                if (sRBException.getType() == -1) break block3;
                throw sRBException;
            }
        }
        return -1;
    }

    public long skip(long l) throws IOException {
        long l2 = this.available();
        if (l2 <= 0L) {
            return 0L;
        }
        if (this.filePointer + l < l2) {
            this.fileSystem.srbObjSeek(this.fd, l, 1);
            this.filePointer += l;
            return l;
        }
        this.fileSystem.srbObjSeek(this.fd, l2, 1);
        this.filePointer += l2;
        return l2;
    }

    public int available() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("size")};
        int n = 0;
        try {
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                n = (int)(Long.parseLong(metaDataRecordListArray[0].getValue("size").toString()) - this.filePointer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n <= 0) {
            return 0;
        }
        return n;
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.fileSystem = null;
        }
        if (this.file != null) {
            this.file = null;
        }
    }

    public String toString() {
        return "Input: " + this.file;
    }
}

