/* GUIRunCIPRes actor calls external applications.

 Copyright (c) 1998-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.cipres.kepler;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.data.IntToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.expr.Parameter;

import org.cipres.kepler.jrun.*;

//////////////////////////////////////////////////////////////////////////
//// GUIRunCIPRes
/**
 * This is the implementation of the GUIRunCIPRes actor using Kepler.
 * This actor calls the external applications.
 * 
 * @author Zhijie Guan  
 * guan@sdsc.edu
*/

public class GUIRunCIPRes extends TypedAtomicActor {

	/** Construct PhyloDataReader source with the given container and name.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the entity cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
	
    public GUIRunCIPRes(CompositeEntity container, String name)
            throws NameDuplicationException, IllegalActionException  {
        super(container, name);
        
		standardOutput = new TypedIOPort(this, "Standard Output", false, true);
		standardOutput.setTypeEquals(BaseType.STRING);

		standardError = new TypedIOPort(this, "Standard Error", false, true);
		standardError.setTypeEquals(BaseType.STRING);

		exitCode = new TypedIOPort(this, "Exit Code", false, true);
		exitCode.setTypeEquals(BaseType.STRING);

		outputParameterValue = new TypedIOPort(this, "Parameter Value (Output)", false, true);
		outputParameterValue.setTypeEquals(BaseType.STRING);
		
		inputParameterName = new TypedIOPort(this, "Input Parameter Name", true, false);
		inputParameterName.setTypeEquals(BaseType.STRING);
		
		inputParameterValue = new TypedIOPort(this, "Input Parameter Value", true, false);
		inputParameterValue.setTypeEquals(BaseType.STRING);

		command = new Parameter(this, "External Command", new StringToken(""));
		uiXMLFile = new Parameter(this, "UI XML File", new StringToken(""));
		outputFile = new Parameter(this, "Standard Output File", new StringToken(""));
		errorFile = new Parameter(this, "Standard Error File", new StringToken(""));
		workingDirectory = new Parameter(this, "Working Direcotry", new StringToken(""));
		parameterForOutput = new Parameter(this, "Parameter to Output", new StringToken(""));
				
        _attachText("_iconDescription", "<svg>\n" +
                "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n" +
                "</svg>\n");
		
    }

    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////

    /** The output port.  The type of this port will be set to String.
     */
	public Parameter command;
	public Parameter uiXMLFile;
    public Parameter outputFile;
	public Parameter errorFile;
	public Parameter workingDirectory;
	public Parameter parameterForOutput;
	
	public TypedIOPort standardOutput = null;
	public TypedIOPort standardError = null;
	public TypedIOPort exitCode = null;
	public TypedIOPort outputParameterValue = null;
	public TypedIOPort inputParameterName = null;
	public TypedIOPort inputParameterValue = null;
	
	///////////////////////////////////////////////////////////////////
	////                    functional variables                   ////
	
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Read and parse the Nexus data.
     *  @exception IllegalActionException If it is thrown by the
     *   send() method sending out the token.
     */
    public void fire() throws IllegalActionException {
		if ( inputParameterValue.hasToken(0) && inputParameterName.hasToken(0) ) {
			super.fire();
			try {			
				GUIRun grun = new GUIRun("External Program");
				
				//		if (command.hasToken(0)) {
				grun.setCommand( ((StringToken)command.getToken()).stringValue() );
				//		}
				
				//		if (uiXMLFile.hasToken(0)) {
				grun.setUIXMLFile( ((StringToken)uiXMLFile.getToken()).stringValue() );
				//		}
				
				//		if (outputFile.hasToken(0)) {
				grun.setOutputFileName( ((StringToken)outputFile.getToken()).stringValue() );
				//		} 
				
				//		if (errorFile.hasToken(0)) {
				grun.setErrorFileName( ((StringToken)errorFile.getToken()).stringValue() );
				//		}
				
				//		if (workingDirectory.hasToken(0)) {
				grun.setWorkingDirectory( ((StringToken)workingDirectory.getToken()).stringValue() );
				//		}
				
				
				grun.setArgumentValue( ((StringToken)inputParameterName.get(0)).stringValue(), ((StringToken)inputParameterValue.get(0)).stringValue() );
				
				grun.setArgumentsWithGUIGen();
				
				grun.setWaitForExecution(true);
				
				grun.execute();
				
				exitCode.send(0, new IntToken(grun.getExitCode()));
				
				standardOutput.send(0, new StringToken(grun.getStandardOutput()));
				standardError.send(0, new StringToken(grun.getStandardError()));
				
				outputParameterValue.send(0, new StringToken( grun.getArgumentValue( ((StringToken)parameterForOutput.getToken()).stringValue() ) ) );
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
    }
	
	/** Post fire the actor. Return false to indicated that the
	 *  process has finished. If it returns true, the process will
	 *  continue indefinitely.
	 */
	public boolean postfire() {
		return false;
	}	
}

