package org.cipres.kepler;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.apache.log4j.Logger;
import java.util.ArrayList;


public class SubsetChooser extends JFrame {

    private static Logger logger = Logger.getLogger(SubsetChooser.class.getName());

    private JPanel pnlSubsetChooser = new JPanel();
    private JPanel pnlMain;
    private DisplayObject[] displayObjects;
    private JCheckBox[] checkboxes;
    private JDialog dialog;


    /*************************************************************
       CONSTRUCTORS
     **************************************************************/
    public SubsetChooser(DisplayObject[] displayObjects) throws Exception {

        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        this.displayObjects = displayObjects;

    }


    public JPanel getSubsetChooserPanel() throws Exception {
    		buildPanel(false);
        return pnlMain;
    }

    
    public DisplayObject[] showSubsetChooserAsDialog() throws Exception {
    	    buildPanel(true);
    		dialog = new JDialog();
		dialog.getContentPane().add(this.pnlMain);
		dialog.setModal(true);
		dialog.pack();
					
		dialog.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e){
				closePanelAsDialog();
	        } 
		});
		
		//make sure dialog size is not > 80% of screen size		
		Dimension dialogSize = dialog.getSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();	
		dialogSize.height = Math.min(dialogSize.height, (int)(screenSize.height * .8));
		dialogSize.width = Math.min(dialogSize.width, (int)(screenSize.width * .8));
		dialog.setSize(dialogSize);
	
		// Center the dialog
		dialog.setLocation((screenSize.width - dialogSize.width) / 2,
				(screenSize.height - dialogSize.height) / 2);	
		
		dialog.show();
		dialog.dispose();
    	
    		return getSubset();
    }
    
    private void closePanelAsDialog(){ 
		dialog.dispose();
    }
    
    public DisplayObject[] getSubset(){
        ArrayList aL = new ArrayList();
        for (int i = 0; i < checkboxes.length; i++) {
            if(checkboxes[i].isSelected()){
                aL.add(this.displayObjects[i]);;
            }
        }
        aL.trimToSize();
        return (DisplayObject[]) aL.toArray(new DisplayObject[aL.size()]);
    }


    /*************************************************************
       PRIVATE METHODS
     **************************************************************/

    private void buildPanel(boolean bShowOkButton) throws Exception {

         // ui elements
         GridBagLayout gridBagLayout1 = new GridBagLayout();
         JLabel lblItem = new JLabel("Item");
         JButton btnSelectAll2 = new JButton("Select All");
         JButton btnDeselectAll1 = new JButton("Deselect All");
         JCheckBox checkBox = new JCheckBox("Checkbox1");
         JButton btnSelectAll1 = new JButton("Select All");
         JButton btnDeselectAll2 = new JButton("Deselect All");
         JScrollPane jScrollPane = new JScrollPane();
        
        //build content panes
        pnlMain = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        pnlMain.setLayout(borderLayout);
        
        pnlSubsetChooser.setLayout(gridBagLayout1);
        this.getContentPane().add(jScrollPane, java.awt.BorderLayout.WEST);
        jScrollPane.getViewport().add(pnlSubsetChooser);
        pnlMain.add(jScrollPane,BorderLayout.WEST);
        jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

        int row = 0;

        //add top-row buttons
        pnlSubsetChooser.add(btnSelectAll1,
                             new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTH, GridBagConstraints.NONE,
                new Insets(15, 15, 15, 0), 0, 0));

        pnlSubsetChooser.add(btnDeselectAll1,
                             new GridBagConstraints(2, row, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE,
                new Insets(15, 5, 15, 15), 0, 0));
        row++;

        // add item header
        lblItem.setFont(new java.awt.Font("Dialog", 1, 14));
        pnlSubsetChooser.add(lblItem,
                             new GridBagConstraints(1, row, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST,
                GridBagConstraints.NONE,
                new Insets(0, 15, 5, 0), 0, 0));

        //add list of selectable items
        checkboxes = new JCheckBox[displayObjects.length];
        for (int i = 0; i < displayObjects.length; i++) {
            row++;
            checkBox = new JCheckBox(displayObjects[i].getName(), true);
            checkboxes[i] = checkBox;
            pnlSubsetChooser.add(checkBox,
                                 new GridBagConstraints(1, row, 2, 1, 0.0, 0.0
                    , GridBagConstraints.WEST, GridBagConstraints.NONE,
                    new Insets(0, 15, 0, 0), 0, 0));
        }

        //add bottom-row buttons
        row++;
        pnlSubsetChooser.add(btnSelectAll2,
                             new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE,
                new Insets(15, 15, 15, 0), 0, 0));

        pnlSubsetChooser.add(btnDeselectAll2,
                             new GridBagConstraints(2, row, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE,
                new Insets(15, 5, 15, 15), 0, 0));

        if(bShowOkButton){
        		JButton btnOk = new JButton("Ok");
        		row++;
        		pnlSubsetChooser.add(btnOk,
                                     new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
                        , GridBagConstraints.WEST, GridBagConstraints.NONE,
                        new Insets(0, 15, 15, 0), 0, 0));
        		btnOk.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent e) {
        	                Component c = (Component) e.getSource();
        	                if (c.hasFocus()) {
        	                		closePanelAsDialog();
        	                }
        	            }
        	    });
        }
        
        //add action listeners
        btnSelectAll1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Component c = (Component) e.getSource();
                if (c.hasFocus()) {
                	selectAll(true);
                }
            }
        });

        btnSelectAll2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Component c = (Component) e.getSource();
                if (c.hasFocus()) {
                    selectAll(true);
                }
            }
        });

        btnDeselectAll1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Component c = (Component) e.getSource();
                if (c.hasFocus()) {
                    selectAll(false);
                }
            }
        });

        btnDeselectAll2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Component c = (Component) e.getSource();
                if (c.hasFocus()) {
                    selectAll(false);
                }
            }
        });


    } //end buildPanel


    private void selectAll(boolean bSelect){
        for (int i = 0; i < checkboxes.length; i++) {
            checkboxes[i].setSelected(bSelect);
        }
    }


}
