/**
 *    '$RCSfile: DataSourceIcon.java,v $'
 *
 *     '$Author: brooke $'
 *       '$Date: 2006/02/03 22:38:20 $'
 *   '$Revision: 1.6 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.datasource;

import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.kernel.attributes.ResizablePolygonAttribute;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class DataSourceIcon {

    private static final String TRANSPARENT = "{0.0, 0.0, 0.0, 0.0}";

    private static final String READY_TEXT = "";
    private static final String READY_TEXT_COLOR = TRANSPARENT;
    private static final String READY_BG_COLOR = "{1.0, 0.81, 0.54, 1.0}";
    private static final String READY_OUTLINE_COLOR = READY_BG_COLOR;

    private static final String BUSY_TEXT = "BUSY";
    private static final String BUSY_TEXT_COLOR = "{0.0, 0.28, 0.54, 1.0}";
    private static final String BUSY_BG_COLOR = TRANSPARENT;
    private static final String BUSY_OUTLINE_COLOR = BUSY_TEXT_COLOR;

    private static final String ERROR_TEXT = "ERROR";
    private static final String ERROR_TEXT_COLOR = "{0.85, 0.11, 0.11, 1.0}";
    private static final String ERROR_BG_COLOR = TRANSPARENT;
    private static final String ERROR_OUTLINE_COLOR = ERROR_TEXT_COLOR;

    //size in pixels of blank margin or buffer-zone to be drawn around the icon:
    private static final int MARGIN_WIDTH = 3;

    /** Icon indicating the communication region. */
    private ResizablePolygonAttribute _poly1;

    private ResizablePolygonAttribute _poly2;

    private TextAttribute _text;

  /**
   * Create the DataSource Icon.
   *
   * @throws NameDuplicationException
   * @throws IllegalActionException
   * @param parent NamedObj
   */
  public DataSourceIcon(NamedObj parent) throws NameDuplicationException, IllegalActionException {
        EditorIcon node_icon = new EditorIcon(parent, "_icon");

        // _poly1 is the "tab" part of the file folder...
        //
        // NOTE - bad code - values showing size of folder are hard-coded,
        //because this code will ultimately be replaced by an SVG image file...
        //
        _poly1 = new ResizablePolygonAttribute(node_icon, "tab");
        _poly1.vertices.setToken("{5,0, 18,0, 19,3, 4,3, 5,0}");
        _poly1.width.setToken("15");
        _poly1.height.setToken("3");
        _poly1.centered.setToken("false");
        _poly1.lineColor.setToken(BUSY_OUTLINE_COLOR);

        // _poly1 is the main "body" of the file folder...
        //
        // NOTE - bad code - values showing size of folder are hard-coded,
        //because this code will ultimately be replaced by an SVG image file...
        //
        _poly2 = new ResizablePolygonAttribute(node_icon, "file");
        _poly2.vertices.setToken("{0,7, 2,5, 32,5, 34,7, 34,27, 32,29, 2,29, 0,27, 0,7}");
        _poly2.width.setToken("34");
        _poly2.height.setToken("24");
        _poly2.centered.setToken("false");
        _poly2.lineColor.setToken(BUSY_OUTLINE_COLOR);

        //_poly3 is a transparent box that acts as a buffer zone or spacer
        //around the entire folder, so the ports don't get too close. The size
        //of this buffer, in pixels, can be set using the "MARGIN_WIDTH"
        //
        // NOTE - bad code - values showing size of folder are hard-coded,
        //because this code will ultimately be replaced by an SVG image file...
        //
        ResizablePolygonAttribute _poly3
          = new ResizablePolygonAttribute(node_icon, "buffer");
        _poly3.vertices.setToken("{-"+MARGIN_WIDTH+",-"+MARGIN_WIDTH+", "
                                 +(34+MARGIN_WIDTH)+",-"+MARGIN_WIDTH+", "
                                 +(34+MARGIN_WIDTH)+","+(29+MARGIN_WIDTH)+", "
                                 +"-"+MARGIN_WIDTH+","+(29+MARGIN_WIDTH)+", "
                                 + "-"+MARGIN_WIDTH+",-"+MARGIN_WIDTH+"}");
        _poly3.width.setToken(""+(2*MARGIN_WIDTH+34));
        _poly3.height.setToken(""+(2*MARGIN_WIDTH+29));
        _poly3.centered.setToken("false");
        _poly3.lineColor.setToken(TRANSPARENT);
        _poly3.fillColor.setToken(TRANSPARENT);

        _text = new TextAttribute(node_icon, "text");
        _text.textSize.setExpression("11");
        _text.bold.setExpression("true");

        //this is the view that shows up as the tree icon:
        setReady();

        node_icon.setPersistent(false);
    }

    /**
     * Set the icon to Busy state
     *
     */
    public void setBusy() {
        setIconStatus(BUSY_TEXT, BUSY_TEXT_COLOR,
                      BUSY_BG_COLOR, BUSY_OUTLINE_COLOR);
    }

    /**
     * Set the icon to Ready state
     *
     */
    public void setReady() {
        setIconStatus(READY_TEXT, READY_TEXT_COLOR,
                      READY_BG_COLOR, READY_OUTLINE_COLOR);
    }

    /**
     * Set the icon to Error state
     *
     */
    public void setError() {
        setIconStatus(ERROR_TEXT, ERROR_TEXT_COLOR,
                      ERROR_BG_COLOR, ERROR_OUTLINE_COLOR);
    }


    /**
     * Set the text and color of the icon
     *
     * @param displayText String
     * @param textColor String
     * @param bgColor String
     * @param outlineColor String
     */
    private void setIconStatus(String displayText, String textColor,
                             String bgColor, String outlineColor) {
      try {
            _text.textColor.setToken(textColor);
            _text.text.setExpression(displayText);
            _poly1.fillColor.setToken(bgColor);
            _poly1.lineColor.setToken(outlineColor);
            _poly2.fillColor.setToken(bgColor);
            _poly2.lineColor.setToken(outlineColor);
        } catch (Exception e) {
          e.printStackTrace();
        }
    }

}
