/**
 *    '$RCSfile: CancelServiceModificationAction.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2005/11/01 20:39:05 $'
 *   '$Revision: 1.4 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.AbstractAction;

/**
 * This action will cancel the modification to servcie. It will go back to default
 * one -read from config file
 * @author Jing Tao
 *  
 */

public class CancelServiceModificationAction extends AbstractAction
{
  private ServicesDisplayFrame frame = null;
  private EcoGridServicesController controller = null;
  private Vector originalServiceList = null;
  /**
   * Constructor
   * @param frame ServicesDisplayFrame
   */
  public CancelServiceModificationAction(String name, ServicesDisplayFrame frame, 
                                         EcoGridServicesController controller, Vector originalServiceList) 
  {
    super(name);
    this.frame = frame;
    this.controller = controller;
    this.originalServiceList = originalServiceList;
  }//CancelServiceModificationAction
  
  /**
   * reset controller and destroy the frame
   * @param e ActionEvent
   */
  public void actionPerformed(ActionEvent e)
  {
      /*EcoGridQueryServicesController newController = new
          EcoGridQueryServicesController();
      Vector list = newController.getServicesList();
      controller.setServiceList(list);*/
      //frame.setEcoGridServicesController(controller);
      
      controller.setServiceList(originalServiceList);
      frame.setVisible(false);
      frame.dispose();
      frame = null;
   
  }//actionPerformed

}//CancelServiceModificationAction