/**
 *    '$RCSfile: InitialRegistrySearchDialogAction.java,v $'
 *
 *     '$Author: tao $'
 *       '$Date: 2005/04/29 20:47:57 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import java.util.Vector;


/**
 * This action will initialize registry search dialog box
 * @author Jing Tao
 */

public class InitialRegistrySearchDialogAction extends AbstractAction
{
  private ServicesDisplayFrame frame           = null;
  private Vector originalServiceVector         = null;
  
  /**
   * Constructor
   * @param name String
   * @param controller EcoGridServicesController
   */
  public InitialRegistrySearchDialogAction(String name, ServicesDisplayFrame frame, 
                                           Vector originalServiceVector) 
  {
    super(name);
    this.frame      = frame;
    this.originalServiceVector = originalServiceVector;
  }//InitialRegistrySearchDialogAction
  
  /**
   * Method to performe the action - initialize a dialog box.
   * @param e ActionEvent
   */
  public void actionPerformed(ActionEvent e)
  {
    frame.setVisible(false);
    // update controller base on user's selection
    frame.updateController();
    RegistrySearchDialog dialog = new RegistrySearchDialog(frame, 
                                   "Search Registry", originalServiceVector);
  }//actionPerformed

}////InitialRegistrySearchDialogAction