/* Translating a simple graph description into a moml description.

@Copyright (c) 2002-2003 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in all
copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                                PT_COPYRIGHT_VERSION 2
                                                COPYRIGHTENDKEY
*/

package org.geon;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


//////////////////////////////////////////////////////////////////////////
////GraphToMoml
/**

@author Efrat Jaeger
@version $Id: GraphToMoml.java,v 1.5 2005/11/01 20:39:08 ruland Exp $
@since Ptolemy II 3.0.2
*/
public class GraphToMoml {

        public GraphToMoml() {
        	actors = new HashMap();
        	directors = new HashMap();
        	portRelations = new HashMap();
        	relations = new HashMap();
        	numRelations = 0;
        }
        
        public static void main(String args[]) throws Exception {
        	//TODO: add a file name to args.
        	
        	GraphToMoml _graphToMoml = new GraphToMoml();
        	_graphToMoml.translate();

        }

        public void addActor() {
        	int beginBrack = axiom.indexOf("(");
        	String axiomPart = axiom.substring(beginBrack+1);
        	int comma = axiomPart.indexOf(",");
        	String actorName = axiomPart.substring(0,comma);
        	axiomPart = axiomPart.substring(comma+1);
        	int endBrack = axiomPart.indexOf(")");
        	String actorClass = axiomPart.substring(0,endBrack);
        	actors.put(actorName, actorClass);
        	//add moml description.
        }
        
        public void addDirector() {
        	
        }
        
        public String addDirectors(int hierarchyLevel) throws ClassNotFoundException {
        	return "";
        }
        
        public String addEntities(int hierarchyLevel) {
        	String entities = "";
        	Iterator keys = actors.keySet().iterator();
        	while (keys.hasNext()) {
        		String actorName = (String) keys.next();
        		String actorClass = (String) actors.get(actorName);
        		Class _actor = null;
        		try {
        			_actor = Class.forName(actorClass);
        		} catch (ClassNotFoundException ex) {
        			System.out.println(ex.getMessage());
        		}
		        /*Constructor[] constructors = _actor.getConstructors();
        		for (int i = 0; i < constructors.length; i++) {
            		Constructor constructor = constructors[i];
            		Class[] parameterTypes = constructor.getParameterTypes();
		            for (int j = 0; j < parameterTypes.length; j++) {
					
                }*/
            }
     //   		NamedObj _tca = (NamedObj) _actor;
      //  		links += tab + "<link port=\"" + portName + "\" relation=\""
        //				 + relationName + "\"/>\n";
        // 	}
        	
        	return entities;
        }
        
        public String addLinks(int hierarchyLevel) {
        	String links = "";
        	Iterator keys = portRelations.keySet().iterator();
        	while (keys.hasNext()) {
        		String portName = (String) keys.next();
        		String relationName = (String) portRelations.get(portName);
        		links += tab + "<link port=\"" + portName + "\" relation=\""
        				 + relationName + "\"/>\n";
         	}
        	
        	return links;
        }
        
        public void addRelation() throws Exception{
        	int beginBrack = axiom.indexOf("(");
        	String axiomPart = axiom.substring(beginBrack+1);
        	int comma = axiomPart.indexOf(",");
        	String outputPort = axiomPart.substring(0,comma);
        	axiomPart = axiomPart.substring(comma+1);
        	int endBrack = axiomPart.indexOf(")");
        	String inputPort = axiomPart.substring(0,endBrack);
        	        	
        	// check if one of the ports is also in another relation.
        	String rel1 = null, rel2 = null;
        	rel1 = (String) portRelations.get(outputPort);
        	rel2 = (String) portRelations.get(inputPort);
        	if (rel1 != null) {
        		if (rel2 != null) {
        			if (!rel1.equals(rel2)) //both ports should be connected to the same relation.
        				throw new Exception("Ports are connected to different relations");
        		} else { // rel2 is null.
        			portRelations.put(inputPort,rel1);
        		}
        	} else { //rel1 is null.
        		if (rel2 != null) {
        			portRelations.put(outputPort,rel2);	
        		} else { //both rels are null.
        			String relName = "relation";
        			if (numRelations > 0) {
        				relName += numRelations;
        			}
        			numRelations++;
        			portRelations.put(outputPort,relName);
        			portRelations.put(inputPort,relName);
        			// TODO: also add the relation to relations var. take care of realtions within a composite entity..
        			
        		}
        	}
        		
       
        		
        	//add moml description.
        }
        
        public String addRelations(int hierarchyLevel) {
        	String relations = "";
        	for (int i=0; i<numRelations; i++) {
        		String rel = "relation";
        		if (i > 0) 
        			rel += i;
        		relations += tab + "<relation name=\"" + rel 
        			+ "\" class=\" ptolemy.actor.TypedIORelation\">\n"
    				+ tab + "</relation>\n";
        		
        	}
        	return relations;
        }
        
        public void translate() throws Exception{
        	
        	String _graphFileStr = 
        		"C:/Documents and Settings/Efrat Jaeger/Desktop/model.pl";
        	int ind = _graphFileStr.lastIndexOf("/");
        	String base = "", fileName = "";
        	if (ind > -1) {
        		base =  _graphFileStr.substring(0,ind);
        		fileName = _graphFileStr.substring(ind+1);
        	}
        	ind = fileName.indexOf(".");
        	String outputName = "";
        	String model = "";
        	if (ind > -1) {
        		model = fileName.substring(0,ind);
        		outputName = model +"1"+ ".xml";
        	} else {
        		throw new Exception("file name exception");
        	}

            try {
            	File graphFile = new File(_graphFileStr);
                in = new BufferedReader(new FileReader(graphFile));
            	File outputFile = new File(base+"/"+outputName);
	            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile.getAbsolutePath(), false));
	            System.out.println(outputFile.getAbsolutePath());
	    	
                // write directly to a file??
                StringBuffer moml = new StringBuffer();
                moml.append("<?xml version=\"1.0\" standalone=\"no\"?>\n"
                        + "<!DOCTYPE entity PUBLIC "
                        + "\"-//UC Berkeley//DTD MoML 1//EN\"\n"
                        + "    \"http://ptolemy.eecs.berkeley.edu"
                        + "/xml/dtd/MoML_1.dtd\">\n");
				moml.append("<entity name=\"" + model + "\" class=\"ptolemy.actor.TypedCompositeActor\">\n"
						+ tab + "<property name=\"_createdBy\""
						+ " class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"3.0.2\">\n"
						+ tab + "</property>\n"
			    		+ tab + "<property name=\"_windowProperties\"" 
			    		+ " class=\"ptolemy.actor.gui.WindowPropertiesAttribute\""
			    		+ " value=\"{bounds={285, 146, 830, 757}}\">\n"
    					+ tab + "</property>\n"
    					+ tab + "<property name=\"_vergilSize\""
    					+ " class=\"ptolemy.actor.gui.SizeAttribute\" value=\"[600, 633]\">\n"
    					+ tab + "</property>\n");
                
                while ( (axiom = in.readLine()) != null) {
                	if (axiom.trim().toLowerCase().startsWith("director")) {
                		addDirector();
                	}
                	else if (axiom.trim().toLowerCase().startsWith("actor")) {
                		// add the actor to the actor list
                		addActor();
                	}
                	else if (axiom.trim().toLowerCase().startsWith("portrelation")) {
                		// add the relation to the relation list.
                		addRelation();
                	}
                }
                	// TODO: currently ignoring composite entities.
                	moml.append(addDirectors(0));
                	moml.append(addEntities(0));
                	moml.append(addRelations(0));
                	moml.append(addLinks(0));
                	moml.append("</entity>");
                	System.out.println(moml.toString());
                	out.write(moml.toString());
                
                	
		        //TODO: TAKE CARE OF COMPOSITE ENTITIES.
	                // 	Iterator iterator = (Iterator)dtde.getTransferable().getTransferData(
	                //                   PtolemyTransferable.namedObjFlavor);
		        	
		/*            while (iterator.hasNext()) {
		                NamedObj dropObj = (NamedObj) iterator.next();
		                // write directly to a file??
		                StringBuffer moml = new StringBuffer();
		                moml.append("<?xml version=\"1.0\" standalone=\"no\"?>\n"
		                        + "<!DOCTYPE entity PUBLIC "
		                        + "\"-//UC Berkeley//DTD MoML 1//EN\"\n"
		                        + "    \"http://ptolemy.eecs.berkeley.edu"
		                        + "/xml/dtd/MoML_1.dtd\">\n");
		
		                moml.append("<group>");
		                if (container != toplevel) {
		                    moml.append("<entity name=\""
		                            + toplevel.getName(container) + "\">\n");
		                }
		                if (dropObj.getMoMLInfo().deferTo != null) {
		                    CompositeEntity sourceContainer =
		                        (CompositeEntity)dropObj.getContainer();
		                    if (sourceContainer != null) {
	                        Iterator imports = sourceContainer.attributeList(
	                                ImportAttribute.class).iterator();
		                        while (imports.hasNext()) {
		                            // FIXME: does this code ever get called?
		                            // There is no code in the tree that instantiates
		                            // an ImportAttribute (8/02)
		                            moml.append(((ImportAttribute)imports.next())
		                                    .exportMoML());
		                        }
		                    }
		                }
		                moml.append(dropObj.exportMoML(name));
		                if (container != toplevel) {
		                    moml.append("</entity>");
		                }
		                moml.append("</group>");
		
		                // NOTE: Have to know whether this is an entity,
		                // port, etc. This seems awkward.
		                MoMLChangeRequest request = null;
		                if (dropObj instanceof ComponentEntity) {
		
		                    // Dropped object is an entity.
		                    // FIXME: Should use the parser from the PtolemyEffigy,
		    
		                }
		            }*/
                in.close();
                out.close();
            } catch(IOException ex) {}
        }

        private BufferedReader in = null;
        
        private String axiom = null;

        // Records all actors and their classes.
        private Map actors = null;
        
        // Records all directors and their classes.
        private Map directors = null;
        
        // Save the relation linked to the port. To record multiple links in a single relation.
        private Map portRelations = null;

        // Records all the relations
        private Map relations = null;

        // The number of added relations.
        private int numRelations = 0;
        
        //indenation.
        private String tab = "    ";
       }