/* Lidar jobs monitoring database processing. 
*/

package org.geon;

import java.io.*;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.*;
import java.lang.Thread;
import java.net.*;
import org.geon.LidarWorkflowExecute;

import javax.servlet.http.HttpServletRequest;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Message;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.InternetAddress;
import java.util.Properties;

//////////////////////////////////////////////////////////////////////////
//// ExecutionThread
/**
* Thread for executing the Lidar processing.
@author Efrat Jaeger  
*/
public class LidarJobConfig {
    
    public LidarJobConfig() {
    }   
    
    public LidarJobConfig(String jobId) {
        setJobId(jobId);
    }   
    
    private String jobId;
    private String userId;
    private String submissionDate;
    private String srid;
    private String xmin;
    private String xmax;
    private String ymin;
    private String ymax;
    private String res;
    private String dmin;
    private String tension;
    private String smooth;
    private String queryTime;
    private String processTime;
    private String completionDate;
    private String[] classifications;
    private String[] processings;
    private String title;
    private String description;
    private String status;
    
    public void setJobConfig(String jobId, String userId, String submissionDate, String srid,
            String xmin, String xmax, String ymin, String ymax, String res, String dmin, 
            String tension, String smooth, String queryTime, String processTime, String completeDate,
            String[] classifications, String[] processings, String jobStatus) {
        this.jobId = jobId;
        setJobConfig(userId, submissionDate, srid, xmin, xmax, ymin, ymax, res, dmin, tension, smooth, 
                queryTime, processTime, completeDate, classifications, processings, jobStatus);
    }

    public void setJobConfig(String userId, String submissionDate, String srid,
            String xmin, String xmax, String ymin, String ymax, String res, String dmin, 
            String tension, String smooth, String queryTime, String processTime, String completeDate,
            String[] classifications, String[] processings, String jobStatus) {
        setUserId(userId);
        setSubmissionDate(submissionDate);
        setSrid(srid);
        setSpatial(xmin, xmax, ymin, ymax);
        setAlgAtts(res, dmin, tension, smooth);
        setTimings(queryTime, processTime, completeDate);
        setClassifications(classifications);
        setProcessings(processings);
        setJobStatus(jobStatus);
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }
    
    public String getJobId() {
        return jobId;
    }
    
    public void setUserId(String userId) {
        this.userId = userId;
    }
    
    public String getUserId() {
        return userId;
    }
    
    public void setSubmissionDate(String submissionDate) {
        this.submissionDate = submissionDate;
    }
    
    public String getSubmissionDate() {
        return submissionDate;
    }

    public void setSrid(String srid) {
        this.srid = srid;
    }
    
    public String getSrid() {
        return srid;
    }

    public void setSpatial(String xmin, String xmax, String ymin, String ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }
    
    public String getXmin() {
        return xmin;
    }
    
    public String getXmax() {
        return xmax;
    }
    
    public String getYmin() {
        return ymin;
    }
    
    public String getYmax() {
        return ymax;
    }
    
    public void setAlgAtts(String res, String dmin, String tension, String smooth) {
        this.res = res;
        this.dmin = dmin;
        this.tension = tension;
        this.smooth = smooth;
    }
    
    public String getRes() {
        return res;
    }
    
    public String getDmin() {
        return dmin;
    }
    
    public String getTension() {
        return tension;
    }
    
    public String getSmooth() {
        return smooth;
    }

    public void setTimings(String queryTime, String processTime, String completeDate) {
        this.queryTime = queryTime;
        this.processTime = processTime;
        this.completionDate = completeDate;
    }
    
    public String getQueryTime() {
        return queryTime;
    }
    public String getProcessTime() {
        return processTime;
    }
    public String getCompletionDate() {
        return completionDate;
    }

    public void setJobDescription(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public String getJobTitle() { 
        return title;
    }
    
    public String getJobDescription() { 
        return description;
    }
    
    public void setJobStatus(String jobStatus) {
        this.status = jobStatus;
    }
    
    public String getJobStatus() { 
        return status;
    }
    
    public void setClassifications(String[] classifications) {
        this.classifications = new String[classifications.length];
        for (int i=0; i<classifications.length; i++) {
            this.classifications[i] = classifications[i];
        }
    }
    
    public String[] getClassifications() { 
        return classifications;
    }
    
    public void setProcessings(String[] processings) {
        this.processings = new String[processings.length];
        for (int i=0; i<processings.length; i++) {
            this.processings[i] = processings[i];
        }
    }
    
    public String[] getProcessings() { 
        return processings;
    }
}
