/**
 *    '$RCSfile: BasicLibraryPane.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2005/02/23 20:09:30 $'
 *   '$Revision: 1.1 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.gui;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JScrollPane;
import javax.swing.JTree;

import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.tree.EntityTreeModel;
import ptolemy.vergil.tree.PTree;
import ptolemy.actor.gui.Configuration;

/**
 * A simple pane used to display the contents of the library tree.
 *
 * @author  Matt Jones
 * @version $Id: BasicLibraryPane.java,v 1.1 2005/02/23 20:09:30 berkley Exp $
 * @since Kepler 1.0
 */
public class BasicLibraryPane extends LibraryPane
{
    /**
     * Construct a new library pane for displaying the tree of actors that can
     * be dragged to the graph editor.
     *
     * @param _libraryModel the model containing the library to be displayed
     */
    public BasicLibraryPane(EntityTreeModel _libraryModel, Configuration config)
    {
        super();

        _library = new PTree(_libraryModel);
        _library.setRootVisible(false);
        //_library.setBackground(BACKGROUND_COLOR);
        _libraryScrollPane = new JScrollPane(_library);
        _libraryScrollPane.setMinimumSize(new Dimension(200, 200));
        _libraryScrollPane.setPreferredSize(new Dimension(200, 325));
        this.add(_libraryScrollPane);
    }

    /**
     * A factory that creates the library panel for the editors.
     */
    public static class Factory extends LibraryPaneFactory
    {
        /** Create an factory with the given name and container.
         *  @param container The container.
         *  @param name The name of the entity.
         *  @exception IllegalActionException If the container is incompatible
         *   with this attribute.
         *  @exception NameDuplicationException If the name coincides with
         *   an attribute already in the container.
         */
        public Factory(NamedObj container, String name)
                throws IllegalActionException, NameDuplicationException
        {
            super(container, name);
        }

        /** Create a library pane that displays the given library of actors.
         *
         *  @param _libraryModel the model containing the actor library
         *  @return A new LibraryPane that displays the library
         */
        public LibraryPane createLibraryPane(EntityTreeModel _libraryModel,
          Configuration config)
        {
                BasicLibraryPane pane = new BasicLibraryPane(_libraryModel,
                  config);
                return pane;
        }
    }


    ///////////////////////////////////////////////////////////////////
    ////                         private variables                 ////

    // FIXME: Comments are needed on all these.
    // FIXME: Need to be in alphabetical order.

    // NOTE: should be somewhere else?
    // Default background color is a light grey.
    private static Color BACKGROUND_COLOR = new Color(0xe5e5e5);
    private JTree _library;
    private JScrollPane _libraryScrollPane;
}
