/**
 *  '$RCSfile: LibrarySearcher.java,v $' '$Author: ruland $' '$Date: 2004/10/13
 *  21:55:10 $' '$Revision: 1.2 $' For Details: http://kepler.ecoinformatics.org
 *  Copyright (c) 2004 The Regents of the University of California. All rights
 *  reserved. Permission is hereby granted, without written agreement and
 *  without license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies of
 *  this software. IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO
 *  ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 *  DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 *  IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 *  DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN
 *  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
 *  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.gui;

import javax.swing.JTree;

/**
 *  this abstract class is should be extended by all classes that provide a
 *  search engine for the actory library. Any local variables in the extending
 *  classes should be initialized in the init method because it is called from
 *  the constructor of this class.
 *
 *@author     berkley
 *@created    February 17, 2005
 */
public abstract class LibrarySearcher
{
  /**
   *  the library to search
   */
  protected JTree library;
  /**
   *  Description of the Field
   */
  protected LibrarySearchResults results;
  /**
   *  Description of the Field
   */
  protected LibrarySearchPane searchPane;


  /**
   *  constructor
   *
   *@param  library     Description of the Parameter
   *@param  searchPane  Description of the Parameter
   */
  public LibrarySearcher(JTree library, LibrarySearchPane searchPane)
  {
    this.library = library;
    this.searchPane = searchPane;
    results = new LibrarySearchResults();
    init();
  }


  /**
   *  search for value in the library
   *
   *@param  value  the value to search for
   *@return        Description of the Return Value
   */
  public abstract LibrarySearchResults search(String value);


  /**
   *  provides any initialization needed prior to searching. It is called when
   *  the class is constructed. Note that any local variables of extending
   *  classes should be initialized in init since it is called be the
   *  constructor of the super class (LibrarySearcher).
   */
  protected abstract void init();
}

