/*
 *  Copyright (c) 2003-2004 The Regents of the University of California.
 *  All rights reserved.
 *  Permission is hereby granted, without written agreement and without
 *  license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies
 *  of this software.
 *  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 *  THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 *  PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 *  PT_COPYRIGHT_VERSION_2
 *  COPYRIGHTENDKEY
 */
package org.kepler.ksw;

import java.util.jar.*;
import java.io.File;
import java.io.IOException;

/**
 *
 */
public class KSWFile extends JarFile
{  
  /**
   * create a new KSWFile from a file
   * @param f the file to create the KSW from
   */
  public KSWFile(File f) throws IOException
  {
    super(f);
  }

  /**
   * create a new KSWFile from a string name
   * @param name the filename to create the KSW from
   */
  public KSWFile(String name) throws IOException
  {
    super(name);
  }

  /**
   * get the manifest
   */
  public KSWManifest getKSWManifest() throws IOException
  {
    return new KSWManifest(super.getManifest());
  }
  
  /**
   * returns an entry by name
   * @param name the name of the entry to return
   */
  public KSWEntry getKSWEntry(String name)
  {
    return (KSWEntry)super.getEntry(name);
  }
}
