/**
 *    '$RCSfile: EcogridRepository.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2006/03/28 00:47:17 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.objectmanager.repository;

import java.io.*;
import java.util.*;

import org.kepler.objectmanager.lsid.KeplerLSID;

import org.ecoinformatics.ecogrid.*;
import org.ecoinformatics.ecogrid.client.*;

/**
 * This class represents an ecogrid repository
 *
 * @author Chad Berkley
 */
public class EcogridRepository extends Repository
{
  private static final String ECOGRIDPUTSERVER = 
    "http://dana.msi.ucsb.edu:8080/ecogrid-put/services/EcogridPutService";
  private static final String ECOGRIDAUTHSERVER = 
    "http://dana.msi.ucsb.edu:8080/ecogrid-auth/services/EcoGridAuthLevelOneService";
 
  public EcogridRepository(String repository, String username, String password)
  {
    super(repository, username, password);
  }
  
  /**
   * Search the repository and return an iterator of results (the Iterator
   * contains KeplerLSIDs of matched items).
   */
  public Iterator search(String queryString)
    throws RepositoryException
  {
    return null;
  }
  
  /**
   * return the object from the repository that has the given lsid
   */
  public Object get(KeplerLSID lsid)
    throws RepositoryException
  {
    return null;
  }
  
  /**
   * put an object into the repository with the given lsid
   */
  public void put(Object o, KeplerLSID lsid)
    throws RepositoryException
  {
    try
    {
      String sessionId = loginEcoGrid(username, password);
      /*System.out.println("sessionid: " + sessionId);
      System.out.println("putting object: " + o.toString());
      System.out.println("with lsid: " + lsid.toString());*/
      String docid = lsid.getNamespace() + "." + lsid.getObject() + "." + 
        lsid.getRevision();
      if(o instanceof File)
      {
        //System.out.println("uploading data file....");
        uploadDataFile(((File)o).getAbsolutePath(), docid, sessionId);
      }
      else 
      {
        //System.out.println("uploading metadata file....");
        uploadMetadata(o.toString(), docid, sessionId);
      }
      //System.out.println("done uploading to ecogrid.");
    }
    catch(Exception e)
    {
      throw new RepositoryException(e.getMessage());
    }
  }
  
  /*
   * This method will operate login action and return a session id
   */
  private String loginEcoGrid(String userName, String password) throws Exception
  {
    String sessionId = null;
    EcogridAuthClient client = new EcogridAuthClient(ECOGRIDAUTHSERVER);
    sessionId = client.login_action(userName, password);
    return sessionId;
  }
  
  /*
   * Method to upload data
   * 
   */
  private void uploadDataFile(String localFileName, 
                              String docid, String sessionId) throws Exception
  {
    int type = EcogridObjType.DATA;
    EcogridPutClient client = new EcogridPutClient(ECOGRIDPUTSERVER);
    client.put(localFileName, docid, type, sessionId);
  }
  
  /*
   * Method to upload metadata
   */
  private void uploadMetadata(String metadataContent, 
                              String docid, String sessionId) throws Exception
  {
    int type = EcogridObjType.METADATA;
    byte[] content = metadataContent.getBytes();
    EcogridPutClient client = new EcogridPutClient(ECOGRIDPUTSERVER);
    client.put(content, docid, type, sessionId);
  }
}
