/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/************************************************
 * This is a Yes/No prompt with variable - length
 * message.  The keyEntered attribute is public, and
 * allows accessing the user-entered option.
 *
 * @author Vitaliy Zavesov
 ************************************************/
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;


public class Interactive extends JFrame {
    String prompt;
    int keyEntered;

    // constructor
    public Interactive(final String p, final int key) {
        setTitle(" ");

        prompt = p;
        keyEntered = key;

        // position our popup window in the center of the screen
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();

        TextCanvas can = new TextCanvas(prompt);
        getContentPane().add(can, "Center");
        can.repaint();

        final JButton yesButton = new JButton("Yes");
        final JButton noButton = new JButton("No");

        ActionListener al = new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    if (ae.getSource() == yesButton) {
                        keyEntered = KeyEvent.VK_Y;
                        hide();
                    } else {
                        keyEntered = KeyEvent.VK_N;
                        hide();
                    }
                }
            };

        yesButton.addActionListener(al);
        noButton.addActionListener(al);

        JPanel pan = new JPanel();
        pan.add(yesButton);
        pan.add(noButton);

        getContentPane().add(pan, "South");

        FontMetrics fm = getFontMetrics(can.f);
        int size = (fm.getHeight() + 6) * (can.cnt + 1);
        size += 75;

        setSize(500, size);

        setLocation(d.width - this.getWidth(), d.height - this.getHeight() -
            30);
    }
}
