/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.awt.Point;
import java.util.Vector;


public class MatchLine {
    // declaring member variables
    TNode leftTNode = null;
    TNode rightTNode;
    Vector mMatchings = new Vector();

    // for drawing multiple matchings 
    Point focusPoint = null;
    boolean selected = false;

    // match index is useful for deleting the object from a vector
    int index = 0;

    // similarity value
    double sim = 1.0;

    // condition to display
    String condition = new String();

    // function for multiple matchings
    String function = new String();

    // operations on a single node
    String operations = new String();

    // grouping attributes
    String grouping = new String();

    // aggregation operand
    String aggregation = new String();

    // the list of other lines with the same left and right
    // nodes
    Vector sameLines = new Vector();

    // this variable is set to true if this line is
    // on top of the other same lines
    boolean topLine = true;

    // constructor
    public MatchLine(TNode leftSelectedTNode, TNode rightSelectedTNode,
        int p_index, double p_sim) {
        leftTNode = leftSelectedTNode;
        rightTNode = rightSelectedTNode;
        index = p_index;
        sim = p_sim;
    }

    // alternate constructor
    public MatchLine(Vector multipleMatchings, TNode rightSelectedTNode,
        int p_index, double p_sim) {
        mMatchings = multipleMatchings;
        rightTNode = rightSelectedTNode;
        index = p_index;
        sim = p_sim;
    }

    public void select() {
        selected = true;
    }

    public void deselect() {
        selected = false;
    }
}
