/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.util.ArrayList;
import java.util.List;


/**
 * MatchingsInSubTree holds a list of matchings from a particular subtree.
 * This is for union matches. E.g, PO1/header/contact matches to
 *   1. PO2/header/contact,
 *   2. PO2/billTo/contact,
 *   3. PO3/shipTo/contact
 * so PO1/header/contact/name has a list of matching candidates under each of
 * the 3 matched subtrees,
 */
class MatchingsInSubTree {
    // the subtree from which the matchings come
    public TNode subTreeRoot;
    public List matchings;

    public MatchingsInSubTree(TNode subRoot, TNode sourceNode) {
        subTreeRoot = subRoot;
        matchings = new ArrayList();
        matchings.add(new Matching(sourceNode, 1.0));
    }

    public MatchingsInSubTree() {
    }
}
