/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.util.Vector;


/**
 * Normalizer is to normalize schema element names to help with longuistic
 * matching using synonym, abbrevation and hypernym tables.
 *
 * @author Guilian Wang
 */
class Normalizer {
    public Domain domain;

    public Normalizer(Domain dm) {
        domain = dm;
    }

    public boolean isSynonym(String name1, String name2) {
        boolean res = false;

        if (domain.synonyms != null) {
            Vector synonymsOfName1 = (Vector) domain.synonyms.get(name1.toLowerCase());

            if ((synonymsOfName1 != null) && !synonymsOfName1.isEmpty()) {
                for (int i = 0; i < synonymsOfName1.size(); i++) {
                    String synonym = (String) synonymsOfName1.get(i);

                    if (synonym.equalsIgnoreCase(name2)) {
                        res = true;
                    }
                }
            }

            Vector synonymsOfName2 = (Vector) domain.synonyms.get(name2.toLowerCase());

            if ((synonymsOfName2 != null) && !synonymsOfName2.isEmpty()) {
                for (int i = 0; i < synonymsOfName2.size(); i++) {
                    String synonym = (String) synonymsOfName2.get(i);

                    if (synonym.equalsIgnoreCase(name1)) {
                        res = true;
                    }
                }
            }
        }

        return res;
    }

    public boolean isHypernym(String name1, String name2) {
        boolean res = false;

        if (domain.hypernyms != null) {
            Vector hypernymsOfName1 = (Vector) domain.hypernyms.get(name1.toLowerCase());

            if ((hypernymsOfName1 != null) && !hypernymsOfName1.isEmpty()) {
                for (int i = 0; i < hypernymsOfName1.size(); i++) {
                    String hypernym = (String) hypernymsOfName1.get(i);

                    if (hypernym.equalsIgnoreCase(name2)) {
                        res = true;
                    }
                }
            }

            Vector hypernymsOfName2 = (Vector) domain.hypernyms.get(name2);

            if ((hypernymsOfName2 != null) && !hypernymsOfName2.isEmpty()) {
                for (int i = 0; i < hypernymsOfName2.size(); i++) {
                    String hypernym = (String) hypernymsOfName2.get(i);

                    if (hypernym.equalsIgnoreCase(name1)) {
                        res = true;
                    }
                }
            }
        }

        return res;
    }

    public boolean isAbbrev(String name1, String name2) {
        // name1 is big, more general, than name2
        boolean res = false;

        if (domain.abbreviations != null) {
            Vector abbrevsOfName1 = (Vector) domain.abbreviations.get(name1.toLowerCase());

            if ((abbrevsOfName1 != null) && !abbrevsOfName1.isEmpty()) {
                for (int i = 0; i < abbrevsOfName1.size(); i++) {
                    String abbrev = (String) abbrevsOfName1.get(i);

                    if (abbrev.equalsIgnoreCase(name2)) {
                        res = true;
                    }
                }
            }
        }

        return res;
    }
}
