/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/*-------------------------------------------------------------------------------
  Guilian Wang
  June 22, 2004

  File Name:      SchemaMorphism.java
  Description:    This program is to define the interface SchemaMorphism. It
                  includes necessary methods for manipulating schema morphisms
  -----------------------------------------------------------------------------*/
import java.util.List;
import java.util.Set;


//import org.w3c.dom.*;
public interface SchemaMorphism {
    public AbstractSchema getSourceSchema();

    public AbstractSchema getTargetSchema();

    public Set getMaps();

    // get view over source schema for input Type targetType in the target schema
    String getView(Type targetType);

    // get condition for the mapping that involves the input Type sourceType 
    String getViewCondition(Type targetType);

    // execute the morphism to transfer the input source data into an 
    // instance of the target schema  
    String execute(String sourceDataFile);

    Set listToSet(List l);

    List setToList(Set s);
}
