/* GriddlesRemoteExec actor subclased from stanard Exec from PtolemyII concepts.
 Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.

  Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.monash.griddles;

import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.expr.Parameter;
import ptolemy.actor.lib.Exec;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.util.*;
import javax.xml.rpc.Stub;
import org.monash.griddles.jobrun.*;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;

import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.Source;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource; 
import javax.xml.transform.stream.StreamResult; 
import java.io.FileOutputStream;



/**
  *   GriddlesRemoteExec is a subclass of the GriddlesExec actor in 
  *   which we split functionality of above actor into two parts and 
  *   merged one part into web service implementation. We added web 
  *   service client functionality into this actor, which allows 
  *   communication between this actor and the web service. This actor 
  *   could be configured from the Kepler user interface for executing 
  *   command at any specified remote location. In addition a certificate 
  *   based security component has been implemented to make communication 
  *   between this actor and the web service fully secure. This actor encodes 
  *   the data with the public key of the web service and signs the data with 
  *   its private key before sending a request to the web service. The web 
  *   service on the other end opens the request by using a client public key 
  *   and decodes by using its private key. The web service executes the command 
  *   with the arguments that were received from the client. The stderr and stdout 
  *   messages generated by the execution are sent in response to the request. 
  *   The response is also encoded and signed with certificates as before. 
  *   The actor upon receiving response opens, decodes and creates stderr and stdout 
  *   objects. Subsequently these messages are streamed to respective ports like previous actor.
  *
  * 
  * This actor defines a new TypedIOPort for subclasses to use especially JGridletRemoteCreate ...   
  * @author Jagan Kommineni, Monash University July 2005
  * @version $Id: GriddlesRemoteExec.java,v 1.5 2006/02/13 07:01:46 kommineni Exp $
  **/


public class GriddlesRemoteExec extends GriddlesExec {
  public GriddlesRemoteExec(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
    super(container, name);
    
    executionHost = new Parameter(this, "executionHost", new StringToken("brecca-2.vpac.org"));
    webServicePort = new Parameter(this, "webServicePort", new StringToken("8080"));
    provider = new Parameter(this, "provider", new StringToken("jwsdp"));
    cmdArgs = new Parameter(this, "cmdArgs", new StringToken("Enter command line arguements"));
    
    executionHost.setStringMode(true);
    webServicePort.setStringMode(true);
    }
    
      public StringParameter newStringParameter(String name) throws NameDuplicationException {
    try {
      _workspace.getWriteAccess();
      StringParameter param = new StringParameter(this, name);
      return param;
      } 
    catch (IllegalActionException ex) {
      // This exception should not occur, so we throw a runtime
      // exception.
      // throw new InternalErrorException(this, ex, null);
      } 
    finally {
      _workspace.doneWriting();
      }
    return null;
    }    
  /** Create a new TypedIOPort with the specified name.
    *  The container of the port is set to this actor.
    *  This method is write-synchronized on the workspace.
    *
    *  @param name The name for the new port.
    *  @return The new port.
    *  @exception NameDuplicationException If the actor already has a port
    *   with the specified name.
    */
    
  public ptolemy.kernel.Port newPort(String name) throws NameDuplicationException {
    try {
      _workspace.getWriteAccess();
      TypedIOPort port = new TypedIOPort(this, name);
      port.setTypeEquals(BaseType.STRING);
      return port;
      } 
    catch (IllegalActionException ex) {
      // This exception should not occur, so we throw a runtime
      // exception.
      throw new InternalErrorException(this, ex, null);
      } 
    finally {
      _workspace.doneWriting();
      }
    }
    
    
  public Parameter executionHost;
  public Parameter webServicePort;
  public Parameter provider;
  public Parameter cmdArgs;
  
  
  private static Stub createProxy() {
    // Note: MyJobrun_Impl is implementation-specific.
    return (Stub)(new MyJobrun_Impl().getJobrunIFPort());
    }
    
    
  public static String classPath;

  public void process(File file)
    {
    if(file.isFile())
      {
      String name = file.getAbsolutePath();
      if(name.endsWith(".jar"))
        {
        classPath = classPath+file.pathSeparator+name;      
        //System.out.println(name);
        }
      }
    }   
  public void visitAllDirsAndFiles(File dir) 
    {
    process(dir);
    
    if (dir.isDirectory()) 
      {
      String[] children = dir.list();
      for (int i=0; i<children.length; i++) 
        {
        visitAllDirsAndFiles(new File(dir, children[i]));
        }
      }
    }    
     /****** 
     The web service stub calls the web service to execute a command on remote 
     location and gets back stderr and stdout messages and these messages are
     streamed to the error and output ports respectively
     Web serves and clients developed by using jwsdp from sun .....
     *******/
  public synchronized void fire() throws IllegalActionException {
    try{
       if((((StringToken)provider.getToken()).stringValue()).equalsIgnoreCase("jwsdp"))
         {
            
         String serviceURL="http://"+(((StringToken)executionHost.getToken()).stringValue())+
                        ":"+(((StringToken)webServicePort.getToken()).stringValue())+
                        "/jobrun-jaxrpc/jobrun";
         System.out.println("Service URL=" + serviceURL);
      
      
         Stub stub = createProxy();

         stub._setProperty(
         javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY,
         serviceURL);
         JobrunIF jobrun = (JobrunIF)stub;
         String commandStr = (((StringToken)command.getToken()).stringValue())+" "+(((StringToken)cmdArgs.getToken()).stringValue());
  
         String stdErrorOut = jobrun.jobrun(commandStr);
      //   System.out.println("Error message:"+ stdErrorOut.getStderror());
      //   System.out.println("Output message:"+ stdErrorOut.getStdout());
        if(stdErrorOut == null)
              stdErrorOut ="%-%No results returned from server";
          System.out.println("ErrorOut="+stdErrorOut);
      
          String[] stringArray = stdErrorOut.split("%-%");
        
          error.send(0, new StringToken(stringArray[0]));
          output.send(0, new StringToken(stringArray[1]));
         }
         else if((((StringToken)provider.getToken()).stringValue()).equalsIgnoreCase("nimrod"))
         {
         }
         else
         {
         long currTime = System.currentTimeMillis()/1000; 
         String exHost =  (((StringToken)executionHost.getToken()).stringValue());
         String stdout1 = "stdout-"+currTime;
         String stderr1 = "stderr-"+currTime;
         String xmlScript= "xmlScript-"+currTime+".xml";
         
      try{
    //Create instance of DocumentBuilderFactory
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    //Get the DocumentBuilder
    DocumentBuilder docBuilder = factory.newDocumentBuilder();
    //Create blank DOM Document
    Document doc = docBuilder.newDocument();

    //create the root element
    Element root = doc.createElement("project");
    //all it to the xml tree
    doc.appendChild(root);
    
     //create a comment
      //Comment comment = doc.createComment("This is comment");
      //add in the root element
      //root.appendChild(comment);

    //create child element
    Element childElement = doc.createElement("include");
    //Add the atribute to the child
    childElement.setAttribute("file","cogkit.xml");
    root.appendChild(childElement);
    
    childElement = doc.createElement("task:execute");
    childElement.setAttribute("executable", (((StringToken)command.getToken()).stringValue()));
    childElement.setAttribute("stdout", stdout1);
    childElement.setAttribute("stderr", stderr1);
    childElement.setAttribute("arguments", ((StringToken)cmdArgs.getToken()).stringValue());
    childElement.setAttribute("host", exHost);
    childElement.setAttribute("provider", (((StringToken)provider.getToken()).stringValue()));
    root.appendChild(childElement);
    
    childElement = doc.createElement("task:transfer");
    childElement.setAttribute("srchost", exHost);
    childElement.setAttribute("srcfile", stdout1);
    childElement.setAttribute("destfile", stdout1);
    childElement.setAttribute("desthost", "localhost");
    childElement.setAttribute("provider", "gridftp");
    root.appendChild(childElement);
    
    childElement = doc.createElement("task:transfer");
    childElement.setAttribute("srchost", exHost);
    childElement.setAttribute("srcfile", stderr1);
    childElement.setAttribute("destfile", stderr1);
    childElement.setAttribute("desthost", "localhost");
    childElement.setAttribute("provider", "gridftp");
    root.appendChild(childElement);

    TransformerFactory tranFactory = TransformerFactory.newInstance(); 
    Transformer aTransformer = tranFactory.newTransformer(); 

    Source src = new DOMSource(doc);
    FileOutputStream fos = new FileOutputStream(xmlScript); 
    Result dest = new StreamResult(fos); 
    aTransformer.transform(src, dest); 
    
    

    }catch(Exception e){
      System.out.println(e.getMessage());
    }


      String kepler = System.getProperty("KEPLER");
      File kfile = new File(kepler+"/cog");       
      visitAllDirsAndFiles(kfile);    
      classPath += kfile.pathSeparator;
      classPath += System.getProperty("java.class.path","."); 
         String wfCommnad =  "java -classpath "+classPath+" org.globus.cog.karajan.Loader "+ xmlScript;
         
         //System.out.println(wfCommnad);
         executeCommand(wfCommnad); 

 
        String stdOutStr="";
        String stdErrStr="";
        String line ;
                  
        BufferedReader br = new BufferedReader(new FileReader(new File(stdout1)));  
           while ( (line=br.readLine()) != null ) { 
              stdOutStr += line;
              stdOutStr += "\n";                 
           } 
        br.close();
        
        br = new BufferedReader(new FileReader(new File(stderr1)));  
           while ( (line=br.readLine()) != null ) { 
              stdErrStr += line;
              stdErrStr += "\n";                 
           } 
        br.close();
        error.send(0, new StringToken(stdErrStr));
        output.send(0, new StringToken(stdOutStr));
        
        executeCommand("rm "+stdout1); 
        executeCommand("rm "+stderr1); 
        executeCommand("rm "+xmlScript); 
        
        System.out.println("The process is successfully completed  ");
         }

      }
    catch(Exception ex) 
      { 
      System.out.println("The exception raised the message "+ex.getMessage());        
      ex.printStackTrace();      
      }

    }
       
  public static boolean executeCommand(String command) {
    Process process = null;
    try {
      //System.out.println("Executing external command " + command);
      process = Runtime.getRuntime().exec(command);
      }
    catch (IOException e) {
      System.out.println(e.toString());
      return false;
      }
    InputStream inputStream = process.getInputStream();
    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
    InputStream errorStream = process.getErrorStream();
    BufferedInputStream bufferedErrorStream = new BufferedInputStream(errorStream);
    boolean ok = false;
    int exitValue = -999;
    while (!ok) {
      try {
        while (bufferedInputStream.available() > 0 || bufferedErrorStream.available() > 0) {
          while (bufferedInputStream.available() > 0) {
             System.out.print((char)bufferedInputStream.read());
             }
           while (bufferedErrorStream.available() > 0) {
             System.out.print((char)bufferedErrorStream.read());
             }
           }
         }
       catch (IOException e) {
         System.out.println("Couldn't read response");
         }
       try {
         exitValue = process.exitValue();
         System.out.println("Process exit value= " + exitValue); 
         ok = true;
       }
     catch (IllegalThreadStateException e) {
       }
     }
   if(ok){
     // finished running
     if(exitValue == 0) {
       System.out.println("Terminated without any errors");
       }
     else {
       System.out.println("Exit code " + exitValue + " while performing command " + command);
       }
     }
   else {
     process.destroy();
     }
   try {
     while (bufferedInputStream.available() > 0) {
       System.out.print((char)bufferedInputStream.read());
       }
     while (bufferedErrorStream.available() > 0) {
       System.out.print((char)bufferedErrorStream.read());
       }
     }
   catch (IOException e) {
     System.out.println("Couldn't read response");
     }
   return exitValue == 0;
   }
 
 
    
  public boolean postfire() {
    return false;
    }
  }