/* JGridletRemoteCreater 
 
  Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.

  Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY


 */

package org.monash.griddles;


import org.kepler.objectmanager.library.LibraryIndex;
import org.kepler.objectmanager.library.LibraryIndexItem;
import org.kepler.objectmanager.library.LibraryIndexRootItem;
import org.kepler.objectmanager.library.LibraryIndexOntologyItem;
import org.kepler.objectmanager.library.LibraryIndexConceptItem;
import org.kepler.objectmanager.library.LibraryIndexComponentItem;
import org.kepler.objectmanager.lsid.KeplerLSID;
import org.kepler.objectmanager.lsid.LSIDGenerator;
import org.kepler.objectmanager.cache.*;
import org.kepler.objectmanager.ActorMetadata;
import org.kepler.ksw.KSWBuilder;
import org.kepler.objectmanager.lsid.DuplicateLSIDException;
import com.ibm.lsid.LSIDException;
import org.kepler.moml.NamedObjId;
import org.kepler.sms.SemanticType;
import java.io.File;
import ptolemy.kernel.util.NamedObj;
 
public class GriddlesUtil
  {  
  
  /**
   * process the new ksw file into the actor library
   * @param kswFile the file to process
   */
  public static void processKSW(File kswFile)
    {
    try
      {
      KeplerLSID[] actorLSIDs;
      CacheManager cache = CacheManager.getInstance();
      KARCacheObject kco = new KARCacheObject(kswFile);
      //cache.insertObject(kco);
      try
        {
        actorLSIDs = kco.getActors();
        }
      catch(LSIDException lside)
        {
        System.out.println("Error getting actor lsid: " + lside.getMessage());
        return;
        }
      if(actorLSIDs != null)
        {
        System.out.println("processing kar file: " + kswFile.getAbsolutePath());
        
        for(int j=0; j<actorLSIDs.length; j++)
          {             
          ActorCacheObject aco = (ActorCacheObject)cache.getObject(actorLSIDs[j]);                    
          ActorMetadata am = aco.getMetadata();          
        try
          { //build an entity for each actor in the ksw and add it to the actorLibrary
          System.out.println("processing " + am.getLSID());

          LibraryIndexItem subtree = LibraryIndex.getInstance().findItem(new KeplerLSID("urn:lsid:localhost:onto:1:1#PreConfiguredGridletActor"));
          System.out.println("subtreeitem="+subtree);
            
          LibraryIndex.getInstance().add(new LibraryIndexComponentItem(am.getName(), am.getLSID()), subtree);
          LibraryIndex.getInstance().refresh();
          System.out.println("actor " + " loaded into the library in category " + subtree.getName() + " with id " +am.getId());
            
          //  NamedObj actorEntity = am.getActorAsNamedObj(container);
          //  util.EmptyChangeRequest request = new util.EmptyChangeRequest(actorEntity, "request change");
          //  actorEntity.requestChange(request);
          }
        catch(Exception e)
          {
          e.printStackTrace();
          System.out.println("Error creating ComponentEntity from actor " + "metadata: " + e.getMessage());
          return;
          }
        }
      }
    }
  catch(CacheException ce)
    {
    System.out.println("Error with the cache: " + ce.getMessage());
    return;
    }
   }    
  
  }