/* JCOGWorkflowExec actor subclased from stanard Exec from PtolemyII concepts.
 Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.

  Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.monash.griddles;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.StringToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.expr.Parameter;
import ptolemy.actor.TypedIOPort;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.IllegalActionException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

/**
  *   JCOGWorkflowExec is a subclass of the Exec actor in 
  *   which it takes xml configuration file as input and performs 
  *   the experiment as a independent process ......
  * 
  * This actor makes complex applications to run distributed systems .....   
  * @author Jagan Kommineni, Monash University July 2005
  * @version $Id: JCOGWorkflowExec.java,v 1.2 2006/02/13 07:01:46 kommineni Exp $
  **/

public class JCOGWorkflowExec extends TypedAtomicActor {
  public JCOGWorkflowExec(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
    super(container, name);
    modelConfigFile = new FileParameter(this, "modelConfigFile");
    modelConfigFile.setExpression("C:/cogkit/cog/dist/cog-4_1_3/examples/karajan/CCAM_workflow2.xml");
    stdOutFile =new FileParameter(this, "stdOutFile");
    stdErrFile =new FileParameter(this, "stdErrFile");
    stdOutFile.setExpression("C:/qsb_amipxx-OUT/stdout");
    stdErrFile.setExpression("C:/qsb_amipxx-OUT/stderr");
    
    error = new TypedIOPort(this, "error", false, true);
    error.setTypeEquals(BaseType.STRING);
    new Parameter(error, "_showName", BooleanToken.TRUE);


    output = new TypedIOPort(this, "output", false, true);
    output.setTypeEquals(BaseType.STRING);
    new Parameter(output, "_showName", BooleanToken.TRUE);
    }
    
    /*
    configuration file name with fullpath ....
    
    
    */
     public FileParameter modelConfigFile;

      /** Data that is generated by the subprocess on its standard
     *  error.  While the process is running, any error data generated
     *  by the subprocess is stored until the subprocess exits and
     *  then the stored error data is sent to the <i>error</i> port.
     *  If the subprocess generates no data on standard error, then
     *  the empty string (a string of length zero) is generated.
     *  This port is an output port of type String.
     */
     
      public TypedIOPort error;


    /** Data that is generated by the subprocess on standard out.
     *  While the process is running, any output data generated
     *  by the subprocess is stored until the subprocess exits and
     *  then the stored output data is sent to the <i>output</i> port.
     *  If the subprocess generates no data on standard out, then
     *  the empty string (a string of length zero) is generated.
     *  This port is an output port of type String.
     */
    public TypedIOPort output;

    public FileParameter stdOutFile;
    public FileParameter stdErrFile;

     /****** 
     
     *******/
  public static String classPath;

  public void process(File file)
    {
    if(file.isFile())
      {
      String name = file.getAbsolutePath();
      if(name.endsWith(".jar"))
        {
        classPath = classPath+file.pathSeparator+name;      
        //System.out.println(name);
        }
      }
    }   
  public void visitAllDirsAndFiles(File dir) 
    {
    process(dir);
    
    if (dir.isDirectory()) 
      {
      String[] children = dir.list();
      for (int i=0; i<children.length; i++) 
        {
        visitAllDirsAndFiles(new File(dir, children[i]));
        }
      }
    }    
     
  public synchronized void fire() throws IllegalActionException {
    try{
      String kepler = System.getProperty("KEPLER");
      File kfile = new File(kepler+"/cog");       
      visitAllDirsAndFiles(kfile);
      classPath += kfile.pathSeparator;
      classPath += System.getProperty("java.class.path",".");
      
        String wfCommnad =  "java -classpath "+classPath+" org.globus.cog.karajan.Loader "+ (((StringToken)modelConfigFile.getToken()).stringValue());
        //System.out.println(wfCommnad);
        executeCommand(wfCommnad);
         
        String stdOutStr="";
        String stdErrStr="";
        String line ;
                  
        BufferedReader br = new BufferedReader(new FileReader(new File((((StringToken)stdOutFile.getToken()).stringValue()))));  
           while ( (line=br.readLine()) != null ) { 
              stdOutStr += line;
              stdOutStr += "\n";                 
           } 
        br.close();
        
        br = new BufferedReader(new FileReader(new File((((StringToken)stdErrFile.getToken()).stringValue()))));  
           while ( (line=br.readLine()) != null ) { 
              stdErrStr += line;
              stdErrStr += "\n";                 
           } 
        br.close();
        error.send(0, new StringToken(stdErrStr));
        output.send(0, new StringToken(stdOutStr));
        System.out.println("The model has been successfully completed  ");
      }
    catch(Exception ex) 
      { 
      System.out.println("The exception raised the message "+ex.getMessage());        
      ex.printStackTrace();      
      }
    }
       
  public static boolean executeCommand(String command) {
    Process process = null;
    try {
      //System.out.println("Executing external command " + command);
      process = Runtime.getRuntime().exec(command);
      }
    catch (IOException e) {
      System.out.println(e.toString());
      return false;
      }
    InputStream inputStream = process.getInputStream();
    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
    InputStream errorStream = process.getErrorStream();
    BufferedInputStream bufferedErrorStream = new BufferedInputStream(errorStream);
    boolean ok = false;
    int exitValue = -999;
    while (!ok) {
      try {
        while (bufferedInputStream.available() > 0 || bufferedErrorStream.available() > 0) {
          while (bufferedInputStream.available() > 0) {
             System.out.print((char)bufferedInputStream.read());
             }
           while (bufferedErrorStream.available() > 0) {
             System.out.print((char)bufferedErrorStream.read());
             }
           }
         }
       catch (IOException e) {
         System.out.println("Couldn't read response");
         }
       try {
         exitValue = process.exitValue();
         System.out.println("Process exit value= " + exitValue); 
         ok = true;
       }
     catch (IllegalThreadStateException e) {
       }
     }
   if(ok){
     // finished running
     if(exitValue == 0) {
       System.out.println("Terminated without any errors");
       }
     else {
       System.out.println("Exit code " + exitValue + " while performing command " + command);
       }
     }
   else {
     process.destroy();
     }
   try {
     while (bufferedInputStream.available() > 0) {
       System.out.print((char)bufferedInputStream.read());
       }
     while (bufferedErrorStream.available() > 0) {
       System.out.print((char)bufferedErrorStream.read());
       }
     }
   catch (IOException e) {
     System.out.println("Couldn't read response");
     }
   return exitValue == 0;
   }    
  public boolean postfire() {
    return false;
    }
  }