/* Base class for conventional actors that work within an external process environment.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors;

import org.nddp.util.ProcessEnvironment;

import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ObjectToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class EnvironmentActor extends TypedAtomicActor {

    public EnvironmentActor(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);

        // create an input port for receiving a reference to the process environment
        environmentIn = new TypedIOPort(this, "environmentIn", true, false);
        environmentIn.setTypeEquals(BaseType.OBJECT);

        // create an output port for forwarding a reference to the process environment
        environmentOut = new TypedIOPort(this, "environmentOut", false, true);
        environmentOut.setTypeEquals(BaseType.OBJECT);
    }
    
    ///////////////////////////////////////////////////////////////////
    ////                         public variables                  ////

    public TypedIOPort environmentIn;
    public TypedIOPort environmentOut;
    
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    protected ProcessEnvironment environment() throws IllegalActionException {
        
        if (_processEnvironment == null) {
            throw new IllegalActionException("Process environment has not been received.");
        }

        return _processEnvironment;
    }
    
    protected ProcessEnvironment receiveEnvironment() throws NoTokenException, IllegalActionException {
        
        // receive one ObjectToken token on the environmentIn port
        _environmentToken = (ObjectToken) environmentIn.get(0);
        
        // extract the reference to the process environment
        _processEnvironment = (ProcessEnvironment)_environmentToken.getValue();

        // return the process environment
        return _processEnvironment;
    }

    protected void sendEnvironment() throws NoRoomException, IllegalActionException {

        if (_environmentToken == null) {
            throw new IllegalActionException("Process environment has not been received.");
        }
       
        // forward the process environment
        environmentOut.broadcast(_environmentToken);
        _environmentToken = null;
        _processEnvironment = null;
    }
    
    ///////////////////////////////////////////////////////////////////
    ////                    private variables                      ////

    ObjectToken _environmentToken = null;
    ProcessEnvironment _processEnvironment = null;
    
    private static final long serialVersionUID = 1L;
}
