/* TODO One line description of class.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors.phylip;

import java.io.IOException;

import org.nddp.actors.EnvironmentActor;
import org.nddp.exceptions.ExternalApplicationException;
import org.nddp.util.Parameters;
import org.nddp.util.ProcessEnvironment;
import org.nddp.util.ProcessRunnerConcrete;

import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.actor type="phylogenetics"
 *
 *  @author Timothy M. McPhillips
 */

public class RunPars extends EnvironmentActor {

    public RunPars(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);

        jumbleCount = Parameters.intParameter(this, "jumbleCount", 0);
        
        jumbleSeed = Parameters.intParameter(this, "jumbleSeed", 1);

        outgroupIndex = Parameters.intParameter(this, "outgroupIndex", 1);
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public variables                  ////

    public Parameter jumbleCount;
    public Parameter jumbleSeed;
    public Parameter outgroupIndex;
    
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////
    public final void attributeChanged(Attribute attribute) 
    throws IllegalActionException {
            
        
        if (attribute == jumbleCount) {
            
            _jumbleCount = Parameters.intValue(jumbleCount);
                
        } else if (attribute == jumbleSeed) {
            
            int newJumbleSeed = Parameters.intValue(jumbleSeed);
                
            if (newJumbleSeed % 4 != 1) {
                throw new IllegalActionException(
                "jumbleSeed must satisfy: jumbleSeed mod 4 == 1");
            }
                
            _jumbleSeed = newJumbleSeed;
        
        } else if (attribute == outgroupIndex) {
            
            _outgroupIndex = Parameters.intValue(outgroupIndex);
        
        } else {
        
            super.attributeChanged(attribute);
        }
    }    

    public void fire() throws IllegalActionException {
 
        // call superclass method
        super.fire();
        
        // get a reference to the process environment
        ProcessEnvironment processEnvironment = receiveEnvironment();

        // run consense
        try {
            
            // create a new process runner and start consense
            ProcessRunnerConcrete runner = new ProcessRunnerConcrete(
                processEnvironment, System.getProperty("PHYLIP_EXE_DIR") + "/pars");
        
            // write to the standard input of consense
            _writeStandardInput(runner);
            
            // wait for consense to complete
            runner.waitForProgramCompletion();

        } catch (ExternalApplicationException e) {
            e.printStackTrace();
        }

        // forward the process environment
        sendEnvironment();
    }
 
    private void _writeStandardInput(ProcessRunnerConcrete runner) 
        throws ExternalApplicationException {
    
        try {
            // output total steps for each character
            runner.writeToProcess("4");                   
        
            // output all character states at each node of tree
            runner.writeToProcess("5");
            runner.writeToProcess(".");               
                
            // optionally jumble the taxa using the given random number seed
            if (_jumbleCount > 0) {
                runner.writeToProcess("J");
                runner.writeToProcess(String.valueOf(_jumbleSeed));
                runner.writeToProcess(String.valueOf(_jumbleCount));
            }
            // enable use of weights
            runner.writeToProcess("w");           

            // optionally specify taxon to use as outgroup
            if (_outgroupIndex > 0) {
                runner.writeToProcess("O");
                runner.writeToProcess(String.valueOf(_outgroupIndex));
            }

            // accept configuration and begin execution
            runner.writeToProcess("Y");
            
        } catch (IOException e) {
            throw new ExternalApplicationException(
                "Error writing to PARS process");
            }           
    }    
    
    ///////////////////////////////////////////////////////////////////
    ////                    private variables                      ////
    
    private int _jumbleCount;
    private int _jumbleSeed;
    private int _outgroupIndex; 
    private static final long serialVersionUID = 1L;
}
