/* Actor that adds contents of list to collections.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

 package org.nddp.coactors;

import org.nddp.Collection;
import org.nddp.CollectionManager;
import org.nddp.CollectionTypes;
import org.nddp.exceptions.CollectionException;
import org.nddp.util.Parameters;

import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;

/**
 * @nddp.coactor type="general"
 */
public class List extends CollectionTransformer {
 
    public List(CompositeEntity container, String name)
        throws IllegalActionException, NameDuplicationException {
        
        super(container, name);

        values = Parameters.tokenArrayParameter(this, "values", "{0}");
        subCollectionType = 
            Parameters.stringParameter(this, "subCollectionType", "");
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////
    
    public Parameter subCollectionType;
    public Parameter values;
    
	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 
    
    public void _handleCollectionEnd(CollectionManager collectionManager) 
    		throws CollectionException, IllegalActionException {
    	
        
        	if (_subCollectionType == Object.class) { 
            
			for (int i = 0; i < _valueArray.length(); i++) {		    
    				collectionManager.addDataToken(_valueArray.getElement(i));
			}
			
        	} else {

			for (int i = 0; i < _valueArray.length(); i++) {		    
                
                	Collection subCollection;

                	try {
					subCollection = 
					    (Collection)_subCollectionType.newInstance();
                    	
                	} catch (InstantiationException e) {
                	    
                	    throw new IllegalActionException(this, e, 
            	            "Cannot create instance of " + _subCollectionType);

                	} catch (IllegalAccessException e) {
                	    
                	    throw new IllegalActionException(this, e, 
            	            "Cannot create instance of " + _subCollectionType);
                	}
                    
                	CollectionManager subCollectionManager = 
 					manageNewCollection(subCollection,
            	            collectionManager);
                	
    	    			subCollectionManager.addDataToken(
    			        _valueArray.getElement(i));
			}
        	}
    	}

    public void _handleParameterChange(Parameter parameter, Token value) 
		throws IllegalActionException {
        
        	if (parameter == values) {
			_valueArray = Parameters.tokenArrayValue(value);
        	} else if (parameter == subCollectionType) {
			_subCollectionType = CollectionTypes.valueOfToken(value);
        	} else {
            	super._handleParameterChange(parameter, value);
        	}
	}

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    private Class _subCollectionType;
    private ArrayToken _valueArray;
}
