/* Actor that begins workflow segment inside do-while construct.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp.coactors;

import org.nddp.Collection;
import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.CollectionIOPort;
import org.nddp.CollectionTypes;
import org.nddp.tokens.LoopTerminationToken;
import org.nddp.util.Parameters;

import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="general"
 */
public class StartLoop extends CollectionTransformer {

	public StartLoop(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException  {

    	    // call the superclass constructor
        	super(container, name);

        	loopback = CollectionIOPort.createInputPort(this, "loopback");
        	
    		loopCollectionType = 
    		    Parameters.stringParameter(this, "loopCollectionType", "");
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////
	
   	public CollectionIOPort loopback;
	public Parameter loopCollectionType;

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

	public void handleLoopTermination(LoopTerminationToken token) throws IllegalActionException {
	    
		_setInputPort(input);
		_loopCollection = null;
    }

	public void initialize() throws IllegalActionException {
 
	    // call superclass constructor
        	super.initialize();

        	_loopCollection = null;
    		_setInputPort(input);
    }
	
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////

    public CollectionIOPort _getDefaultOutputPort() {
        return output;
    }

    public void _handleCollectionEnd(CollectionManager collectionManager) 
		throws IllegalActionException  {
	    
        if (collectionManager.collection() == _loopCollection) {
	        if (_inputPort() == input) {
	            _setInputPort(loopback);
	        }
	    }
	}
	
    public CollectionHandler.CollectionDisposition _handleCollectionStart(CollectionManager 
        collectionManager) throws IllegalActionException {	    
        
	    if (_loopCollection == null 
	            && _loopCollectionType.isInstance(collectionManager.collection())) {
	        
	        _loopCollection = collectionManager.collection();
	        _loopParentCollection = 
	            collectionManager.parentCollectionManager().collection();
	    }

        return CollectionHandler.PROCESS_AND_FORWARD_COLLECTION;
   	}

    public void _handleParameterChange(Parameter parameter, Token value) 
		throws IllegalActionException {
  	    
		if (parameter == loopCollectionType) {
        		_loopCollectionType = 
        		    CollectionTypes.valueOfToken(value);	
        	} else {
			super._handleParameterChange(parameter, value);
        	}
    }
    
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

	private Collection _loopCollection;	
	private Class _loopCollectionType;  
	private Collection _loopParentCollection;
}