/* Class representing a taxonomic character vector.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny;

public class CharacterVector {
  
    public CharacterVector(int characterCount, CharacterMatrix matrix) {
        
        super();
        
        _characterCount = characterCount;
        _matrix = matrix;
        _states = new char[characterCount];
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

    public final boolean isComplete() { 
        return _nextIndex == _characterCount; 
    }
    
    public void setNextStates(String statesString) {
        
	    for (int i = 0, count = statesString.length(); i < count; i++ ) {
	        
	       	if (_nextIndex == _characterCount ) {
            		throw new IllegalStateException(
        		        "CharacterVector capacity exceeded");
	        }
	       	
			char state = statesString.charAt(i);
			
			if (! Character.isWhitespace(state)) {
			    
				if (state == _matrix._localGapSymbol) {
				    state = CharacterMatrix.STANDARD_GAP_SYMBOL;
				}
				
				if (state == _matrix._localMissingSymbol) {
				    state = CharacterMatrix.STANDARD_MISSING_SYMBOL;
				}
				
				_states[_nextIndex++] = state;
			}
	    }
    }
    
    public char state(int index) { 
        return _states[index]; 
    }
    
    public String toString() {
        return new String(_states);
    }

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////


    private final int _characterCount;
    private final CharacterMatrix _matrix;
    private int _nextIndex = 0;
    private final char[] _states;
}
