/* Class representing a distance matrix.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny;

import java.util.Iterator;

import org.nddp.DomainObjectBase;
import org.nddp.util.Xml;

public class DistanceMatrix extends DomainObjectBase {
    
    public DistanceMatrix(int size) {
        
        super();
        
        _size = size;
        _distanceMatrix = new double[_size][_size];
    }
        
	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
    
    public double getDistance(int taxon1, int taxon2) {
        
        if (taxon1 >= taxon2) {
            return _distanceMatrix[taxon1][taxon2];
        } else {
            return _distanceMatrix[taxon2][taxon1];
        }
    }
        
    public String id() {
        return null;
    	}

    public RowIterator rowIterator() { 
        return new RowIterator(); 
    }
    
    public void setDistance(int taxon1, int taxon2, double distance) {
        
        assertNotWriteLocked();
        
        if (taxon1 >= taxon2) {
            _distanceMatrix[taxon1][taxon2] = distance;
        } else {
            _distanceMatrix[taxon2][taxon1] = distance;
        }
    }

    public int size() {
        return _size;
    }

    public String toString() {
        
        return "";
     }

	public String type() {
	    return "DistanceMatrix";
	}

    public String xmlAttributeString() {
        return Xml.attribute("size", _size);
    }
    
    public String xmlContentString(Xml.Indentation indentation) {

        StringBuffer buffer = new StringBuffer("");

        for (int i = 0; i < _size; i++ ) {
            buffer.append(indentation.toString() + "<MatrixRow" +
                Xml.attribute("values", matrixRowString(i)) + 
                " />\n");
        }
        
        return buffer.toString();
    }
        
    ///////////////////////////////////////////////////////////////////
    ////                      private methods                      ////
    
    private String matrixRowString(int rowIndex) {

        StringBuffer buffer = new StringBuffer("");
        for (int columnIndex = 0; columnIndex <= rowIndex; columnIndex++ ) {
            if (columnIndex != 0) {
                buffer.append(" ");
            }
            buffer.append(_distanceMatrix[rowIndex][columnIndex]);
        }
        
        return buffer.toString();
    }
    
        
	///////////////////////////////////////////////////////////////////
	////                      private variables                    ////
	
    private final int _size;
	private final double _distanceMatrix[][];

    public class RowIterator implements Iterator {
        
        private RowIterator() {}
        
        ///////////////////////////////////////////////////////////////////
        ////     public methods for CharacterMatrix.RowIterator        ////

        public boolean hasNext() { return _rowIndex < _size;}
        public Object next() { return matrixRowString(_rowIndex++); }
        public void remove() { throw new UnsupportedOperationException(); }

        ///////////////////////////////////////////////////////////////////
        ////     private variables for CharacterMatrix.RowIterator     ////

        private int _rowIndex = 0;
    }

}
