/* Class representing a Nexus file block.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NexusBlock {

    public NexusBlock(String blockString) {
        
        Matcher commandMatcher = NEXUS_COMMAND_PATTERN.matcher(blockString);
        
        commandMatcher.find();

        String commandHeader = commandMatcher.group();
        _type = commandHeader.substring(6,commandHeader.length() - 1).
        			trim().toUpperCase();
        
        while (commandMatcher.find()) {
            NexusCommand command = new NexusCommand(commandMatcher.group());
            _commandList.add(command);
            _commandMap.put(command.name(), command);
        }
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
	    
    public Iterator commandIterator() {
        return _commandList.iterator();
    }
    
    public NexusCommand getCommand(String name) {
        
        return (NexusCommand) _commandMap.get(name);
    }
    
    public String type() {
        return _type;
    }
    
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
    
    private final List _commandList = new LinkedList();
    private final Map _commandMap = new HashMap();
    private final String _type;
    
    private static final Pattern NEXUS_COMMAND_PATTERN = 
        Pattern.compile("[^;]*?;", Pattern.DOTALL);
}

