/* Collection token containing a single domain object.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.tokens;

import org.nddp.Collection;
import org.nddp.DomainObject;
import org.nddp.util.Xml;

/**
 * @author Timothy M. McPhillips
 */
public class DomainObjectToken extends CollectionTokenSkeleton {

    public DomainObjectToken(Collection collection, DomainObject object) {
        
        super(collection);
        
		_object = object;
    }
    
	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
	
	public DomainObject object() {
	    return _object;
	}

	public String toString() {

        	return toXmlString(true);
    }
	
	public String toXmlString(boolean showType) {
	    
	    return toXmlString(_object, showType, false, new Xml.Indentation("",""));
	}
	
	public static String toXmlString(DomainObject object, boolean showType,
        	boolean showContents, Xml.Indentation indentation) {
	    
   	    StringBuffer buffer = new StringBuffer("<DomainObject");
    
   	    if (showType) {
   	        buffer.append(Xml.attribute("type", 
                object.getClass().getName().toString()));
   	    }
   	    
   	    if (object.id() != null) {
   	        buffer.append(Xml.attribute("id", object.id()));
   	    }
   	    
   	    String attributeString = object.xmlAttributeString();
   	    
   	    if (attributeString != null) {
	   	    buffer.append(attributeString);
   	    }
   	    
   	    if (showContents) {
   	        
   	        	indentation.increase();
        		String contentString = object.xmlContentString(new Xml.Indentation(indentation));
            	indentation.decrease();
            	
            	if (contentString != null) {	    			
	   	        buffer.append(">\n" + contentString);            	
	   	        buffer.append(indentation.toString() + "</DomainObject>");
	   	        
            	} else {
		   	    buffer.append(" />");
            	}
            	
   	    } else {
   	        
	   	    buffer.append(" />");
   	    }
   	    
   	    return buffer.toString();
	}
	
	///////////////////////////////////////////////////////////////////
	////                      private variables                   //// 

    private final DomainObject _object;
}
