/* A thread that asynchronously routes data from a BufferedReader to a Writer.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;


public class AsyncStreamRouter extends Thread {

    public AsyncStreamRouter(BufferedReader reader, Writer writer) {
        
        _bufferedReader = reader;
        
        if (writer != null) {
            _writer = writer;
        } else {
            _writer = new StreamDiscarder();
        }
    }
    
	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
    
    public void run() {
        
		String line;
        
		do {	
		 	try {
		 	    line = _bufferedReader.readLine();
		 	    
		 	    if (line != null) {
	                _writer.write(line);
		 	    }
                
            } catch (IOException e) {
                
                System.out.println("I/O error in AsyncStreamRouter.run()");
                line = null;
                e.printStackTrace();                
            }
            
		} while (line != null);
    }
    
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    private final BufferedReader _bufferedReader;
    private final Writer _writer;
}