/* GridFTP...
 Copyright (c) 2000-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.
 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.
 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
 */

package org.sdm.spa;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

import org.globus.ftp.GridFTPClient;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;

//////////////////////////////////////////////////////////////////////////
//// FileStager
/**
 * This actor gets a set of files from a specified local directory, copies them
 * into a specified Globus machine, and sends back the list of file paths as
 * string when it is done.
 *
 * @author Ilkay Altintas (Built on top of Steve Mock's GridFTP.)
 * @version $Id: FileStager.java,v 1.5 2006/04/04 22:37:02 altintas Exp $
 */

public class FileStager
    extends TypedAtomicActor {

  public FileStager(CompositeEntity container, String name) throws
      IllegalActionException, NameDuplicationException {
    super(container, name);

    certificate = new TypedIOPort(this, "certificate", true, false);
    certificate.setTypeEquals(BaseType.STRING);
    new Attribute(certificate, "_showName");

    filesToPut = new TypedIOPort(this, "filesToPut", true, false);
    filesToPut.setTypeEquals(BaseType.STRING);
    new Attribute(filesToPut, "_showName");

    stagedFiles = new TypedIOPort(this, "stagedFiles", false, true);
    stagedFiles.setTypeEquals(BaseType.STRING);
    new Attribute(stagedFiles, "_showName");

    destHost = new StringAttribute(this, "DestinationHostname");
    destDirPath = new StringAttribute(this, "DestinationDirectoryPath");

    _attachText("_iconDescription", "<svg>\n"
                + "<rect x=\"-25\" y=\"-20\" "
                + "width=\"50\" height=\"40\" "
                + "style=\"fill:white\"/>\n"
                + "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
                + " 15,-10 15,8, -15,8\" "
                + "style=\"fill:red\"/>\n"
                + "<text x=\"-20\" y=\"19\""
                + "style=\"font-size:11; fill:black; font-family:SansSerif\">"
                + "STAGER</text>\n"
                + "</svg>\n");
  }

  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////


  /**
    * The Globus proxy certificate generated by the GlobusProxy actor.
    */
  public TypedIOPort certificate;

  /**
   * The list of file paths to stage in string form seperated by semicolons.
   */
   public TypedIOPort filesToPut;

   /**
    * The list of file paths for the copied files.
    * (In string form seperated by semicolons.)
    */
   public TypedIOPort stagedFiles;
   /**
     * The url to get the files from.
     */
  public StringAttribute destHost;

  /**
   * Full path to the destination directory to copy the files into.
   */
  public StringAttribute destDirPath;

  ///////////////////////////////////////////////////////////////////
  ////                         public methods                    ////

  /** If the specified attribute is <i>fileOrURL</i> and there is an
   *  open file being read, then close that file and open the new one;
   *  if the attribute is <i>numberOfLinesToSkip</i> and its value is
   *  negative, then throw an exception.  In the case of <i>fileOrURL</i>,
   *  do nothing if the file name is the same as the previous value of
   *  this attribute.
   *  @param attribute The attribute that has changed.
   *  @exception IllegalActionException If the specified attribute
   *   is <i>fileOrURL</i> and the file cannot be opened, or the previously
   *   opened file cannot be closed; or if the attribute is
   *   <i>numberOfLinesToSkip</i> and its value is negative.
   */
  public void attributeChanged(Attribute attribute) throws
      IllegalActionException {

    super.attributeChanged(attribute);
  }

  /** Output the data lines into an array.
   *  @exception IllegalActionException If there's no director.
   */

  public void fire() throws IllegalActionException {
    super.fire();

    //Get the values of the parameters
    String sourceHostString = "localhost";
    _debug("<SOURCE_HOST_NAME>" + sourceHostString + "</SOURCE_HOST_NAME>");
    int sourcePort = 2811;
    String destHostString = destHost.getExpression();
    _debug("<DEST_HOST_NAME>" + destHostString + "</DEST_HOST_NAME>");
    String destDirPathString = destDirPath.getExpression();
    _debug("<DEST_PATH>" + destHostString + "</DEST_PATH>");
    int destPort = 2811;

    String failMsg = "GridFTP transfer failed because of: ";

    /* Consume the filesToPut token if there's one.
     */
    Token tokenFiles = null;
    String filesStream = null;
    try {
      tokenFiles = filesToPut.get(0);
    }
    catch (Exception ex) {
      _debug("filesToPut string is null.");
    }

//    try {
      ExtendedGSSManager manager = (ExtendedGSSManager) ExtendedGSSManager.
          getInstance();
      //get the proxy string fed into the input port
      Token token = null;
      try {
        token = certificate.get(0);

        if (token != null) {
          _proxy = manager.createCredential( (token.toString()).getBytes(),
                                            ExtendedGSSCredential.
                                            IMPEXP_OPAQUE,
                                            GSSCredential.DEFAULT_LIFETIME,
                                            null, // use default mechanism - GSI
                                            GSSCredential.
                                            INITIATE_AND_ACCEPT);
        }
      }
      catch (Exception ex) {
        _proxy = null;
        _debug("Proxy is null.");
      }
//    } catch (org.ietf.jgss.GSSException gsse) {
//      throw new IllegalActionException(failMsg + gsse.toString());
//    }

    if (tokenFiles != null) {
      filesStream = new String(tokenFiles.toString());
      _debug("<FILES_TO_PUT>" + filesStream + "<FILES_TO_PUT>");
      filesStream = filesStream.substring(1, filesStream.length() - 1);
    }
    //Tokenize the filesStream to get the name of each file.
    StringTokenizer st = new StringTokenizer(filesStream, ";", false);
    _destFileStream = "";
    while (st.hasMoreTokens()) {
      _sourceFileString = st.nextToken();
      _debug("<SOURCE_FILE_PATH>" + _sourceFileString + "</SOURCE_FILE_PATH>");

      int slashIndex = _sourceFileString.lastIndexOf('/');
      String tmpFileNameString = _sourceFileString.substring(slashIndex + 1);
      _destFileString = destDirPathString + "/" + tmpFileNameString;
      _debug("<DEST_FILE_PATH>" + _destFileString + "</DEST_FILE_PATH>");

      _destFileStream += _destFileString + ';';

      try {
        if (sourceHostString.equals("") ||
            sourceHostString.equals("localhost")) {
          _gftpc_dest = new GridFTPClient(destHostString, destPort);
           _gftpc_dest.authenticate(_proxy);
          _gftpc_dest.put(new File(_sourceFileString), _destFileString, false);
        }
      }
      catch (IOException ioe) {
        throw new IllegalActionException(failMsg + ioe.toString());
      }
      catch (org.globus.ftp.exception.ServerException se) {
        throw new IllegalActionException(failMsg + se.toString());
      }
      catch (org.globus.ftp.exception.ClientException ce) {
        throw new IllegalActionException(failMsg + ce.toString());
      }
    }

    _debug("Done with GridFTP transfer.");
    _destFileStream = _destFileStream.substring(0,_destFileStream.length() - 1);
    stagedFiles.broadcast(new StringToken(_destFileStream));
  }

  /** Post fire the actor. Return false to indicated that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   */

  public boolean postfire() {
    return false;
  }

  /** Open the file or URL and read the first line, and use the
   *  first line to set the type of the output.
   *  @exception IllegalActionException If the file or URL cannot be
   *  opened, or if the first line cannot be read.
   */
  public void preinitialize() throws IllegalActionException {
    super.preinitialize();
  }

///////////////////////////////////////////////////////////////////
////                         protected members                 ////

///////////////////////////////////////////////////////////////////
////                         private methods                   ////

///////////////////////////////////////////////////////////////////
////                         private members                   ////

  private GridFTPClient _gftpc;
  private GridFTPClient _gftpc_dest;
  private GSSCredential _proxy;

  private String _destFileString = "";
  private String _destFileStream = "";
  private String _sourceFileString = "";
  /** Result string Variable. */
  private String _result = new String("");

}