/* An actor that pauses a model executing and holds the token until 
the model is resumed.

 Copyright (c) 1997-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.sdm.spa;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Sink;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.TransientSingletonConfigurableAttribute;

//////////////////////////////////////////////////////////////////////////
//// Pause
/**
 * This actor is used for putting an expected pause in the workflow 
 * specification to allow for execution to pause until the outputs until 
 * that time are reviewed and the workflow is paused. This actor is mainly 
 * useful for long-running jobs.
 * 
 <P>Implementation of this actor is based on the stop actor code by Edward A. Lee.

   @author Ilkay Altintas
   @version $Id: Pause.java,v 1.7 2005/11/01 20:39:14 ruland Exp $

   @category.name flow control
   @category.name local

   @entity.description input Input content. Can be any input. They will  
      be transfered to the next actor once the workflow resumes.

**/

public class Pause extends Sink{

	/** Construct an actor in the specified container with the specified
     *  name.
     *  @param container The container.
     *  @param name The name of this actor within the container.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the name coincides with
     *   an actor already in the container.
     */
    public Pause(CompositeEntity container, String name)
            throws IllegalActionException, NameDuplicationException {
        super(container, name);

        input.setTypeEquals(BaseType.BOOLEAN);
        output = new TypedIOPort(this, "output", false, true);
        output.setTypeEquals(BaseType.STRING);
        // Icon is a yield sign.
        _attachText("_iconDescription", "<svg>\n"
                + "<polygon points=\"0,24 24,-22 -24,-22\" "
                + "style=\"fill:red\"/>\n"
                + "<text x=\"-15\" y=\"-8\""
                + "style=\"font-size:11; fill:white; font-family:SansSerif\">"
                + "PAUSE</text>\n"
                + "</svg>\n");  
        // Hide the name because the name is in the icon.
        new TransientSingletonConfigurableAttribute(this, "_hideName");
    }
    
    /////// public vars    //////
    ///						///
    /**
     * @entity.description The inputs to be trasfered to the next actors.
     */
    public TypedIOPort output;


    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////
    
  public void fire() throws IllegalActionException  {
        boolean result = false;
        Nameable container = getContainer();        
        // NOTE: We need to consume data on all channels that have data.
        // If we don't then DE will go into an infinite loop.
        for (int i = 0; i < input.getWidth(); i++) {
            if (input.hasToken(i)) {
                if (((BooleanToken)input.get(i)).booleanValue()) {
                    result = true;
                }
            }
        }
        

        resumeButton = new JButton("Resume model execution.");
        resumeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
            	manager.resume();
		_frame.dispose();
      	    }
        });
        
        _panel = new JPanel();
        _panel.add(resumeButton);

        if (_container == null) {
            _frame = new JFrame(getFullName());
            _frame.getContentPane().add(_panel);
            _frame.setSize(200,250);
        } else {
            _container.add(_panel);
            _panel.setBackground(null);
            _panel.setBorder(new LineBorder(Color.black));
        }
        _panel.setBorder(BorderFactory.createTitledBorder("The border title goes here..."));
        if (_frame != null) {
            _frame.setVisible(true);
        }
        if (result) {
            if (container instanceof CompositeActor) {
                manager = ((CompositeActor)container).getManager();
                if (manager != null) {
                    manager.pause();
                } else {
                    throw new IllegalActionException(this,
                            "Cannot pause without a Manager.");
                }
            } else {
                throw new IllegalActionException(this,
                        "Cannot pause without a container that is a CompositeActor.");
            }
        }
    sendToken("ilkay");
    return; 
  }

    /** Read one token from each input channel that has a token,
     *  and if any token is true, call finish() on the manager.
     *  @exception IllegalActionException If there is no director or
     *   if there is no manager, or if the container is not a
     *   CompositeActor.
     *  @return False if a stop is requested, and true otherwise.
     */
    public boolean postfire() throws IllegalActionException {
            	//sendToken("ilkay");
    	return false;
    }
    
  protected void sendToken(Object o)
    throws ClassCastException, IllegalActionException  {
    output.send(0, new StringToken((String)o));
    //getToken will always return a stringToken here.
  }        





/*    public void initialize() throws IllegalActionException {
        super.initialize();
        if (_frame == null) {
            // No container has been specified for the shell.
            // Place the shell in its own frame.
            // Need an effigy and a tableau so that menu ops work properly.
            Effigy containerEffigy = Configuration.findEffigy(toplevel());
            if (containerEffigy == null) {
                throw new IllegalActionException(this,
                        "Cannot find effigy for top level: "
                        + toplevel().getFullName());
            }
            try {
                ButtonEffigy buttonEffigy = new ButtonEffigy(
                        containerEffigy, containerEffigy.uniqueName("shell"));
                // The default identifier is "Unnamed", which is no good for
                // two reasons: Wrong title bar label, and it causes a save-as
                // to destroy the original window.
                buttonEffigy.identifier.setExpression(getFullName());
                ButtonTableau tableau = new ButtonTableau(
                        buttonEffigy, "tableau");
                _frame = tableau.frame;
                shell = tableau.shell;
                shell.setInterpreter(this);
                // Prevent editing until the first firing.
                shell.setEditable(false);
            } catch (Exception ex) {
                throw new IllegalActionException(this, null, ex,
                        "Error creating effigy and tableau");
            }
            _windowProperties.setProperties(_frame);
            _frame.show();
        } else {
         //   shell.clearJ();
        }
        /* NOTE: This causes a bug where manual resizes of the window
           get overridden on re-run.
           if (_frame != null) {
           _frame.show();
           }
        */
        /*
        _firstTime = true;
        _returnFalseInPostfire = false;
    }



*/

    protected JPanel _panel;

    private Container _container;
    // The frame into which to put the button, if any.
    private JFrame _frame;
    
    Manager manager;
    JButton resumeButton;
}

