/* Represents an undo or redo action.

 Copyright (c) 2003-2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY
 */
package ptolemy.kernel.undo;

//////////////////////////////////////////////////////////////////////////
//// UndoAction

/**
 This interface represents an undo or redo action that is
 maintained on an undo/redo stack, such as that maintained by
 UndoStackAttribute.

 @see UndoStackAttribute
 @author  Edward A. Lee
 @version $Id: UndoAction.java,v 1.10 2005/07/08 19:59:14 cxh Exp $
 @since Ptolemy II 3.1
 @Pt.ProposedRating Green (eal)
 @Pt.AcceptedRating Green (hyzheng)
 */
public interface UndoAction {
    // NOTE: Except for the fact that execute() throws Exception,
    // we could have used the Java Runnable interface.
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Execute the undo or redo action.
     *  @exception Exception If something goes wrong.
     */
    public void execute() throws Exception;
}
