/**
 *    '$RCSfile: FileReader.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2005/11/01 20:39:16 $'
 *   '$Revision: 1.5 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package util;

import java.io.BufferedReader;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

/**
 * class to extend the FileReader so that you can input the name of the
 * file to be read from an input port.
 * NOTE:
 * Originally written by Yang Zhao of the Ptolemy project.
 */
public class FileReader extends TypedAtomicActor
{
  public PortParameter filename;
  public TypedIOPort output;

  /**
   *@param  workspace
   *@exception  IllegalActionException
   *@exception  NameDuplicationException
   */
  public FileReader(Workspace workspace)
    throws IllegalActionException, NameDuplicationException
  {
    super(workspace);
    output = new TypedIOPort(this, "output", false, true);
    filename = new PortParameter(this, "filename");
    output.setTypeEquals(BaseType.STRING);
  }

  /**
   *@param  container                     The container.
   *@param  name                          The name of this actor.
   *@exception  IllegalActionException    If the container is incompatible
   *   with this actor.
   *@exception  NameDuplicationException  If the name coincides with
   *   an actor already in the container.
   */
  public FileReader(CompositeEntity container, String name)
    throws IllegalActionException, NameDuplicationException
  {
    super(container, name);
    output = new TypedIOPort(this, "output", false, true);
    filename = new PortParameter(this, "filename");
    output.setTypeEquals(BaseType.STRING);
  }

  /**
   * Output the data read from the port
   *
   *@exception  IllegalActionException  If there is no director.
   */
  public void fire()
    throws IllegalActionException
  {
    try
    {
      BufferedReader reader;
      filename.update();
      StringToken st = (StringToken)filename.getToken();
      String filenameStr = st.toString();
      if(filenameStr.indexOf("\"") != -1)
      { //trim the quotes
        filenameStr = filenameStr.substring(1, filenameStr.length() - 1);
      }
      reader = new BufferedReader(new java.io.FileReader(filenameStr));

      StringBuffer momlBuffer = new StringBuffer();
      String newline = System.getProperty("line.separator");

      while(true)
      {
        String line = reader.readLine();

        if(line == null)
        {
          break;
        }
        momlBuffer = momlBuffer.append(line);
        momlBuffer = momlBuffer.append(newline);
      }

      String momlString = momlBuffer.toString();

      output.broadcast(new StringToken(momlString));
    }
    catch(Exception ex)
    {
      throw new IllegalActionException(this, ex.getMessage());
    }
  }

  /**
   *@return boolean
   *@exception  IllegalActionException  If the superclass throws it.
   */
  public boolean prefire()
    throws IllegalActionException
  {
    filename.update();
    if(filename.getToken() != null)
    {
      return true;
    }
    return false;
  }

}

