/**
 *  '$RCSfile: MessageDigestTest.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: @authors@
 *    Release: @release@
 *
 *   '$Author: higgins $'
 *     '$Date: 2006/03/26 23:27:12 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import java.util.*;
import java.io.*;
import java.security.*;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import util.PersistentVector;

/**
 *  MessageDigestTest.java
 *  The purpose of this actor is calculate the message digest for the contents 
 *  of a file. The MD5 algorithm is used and the result is compared to a 
 *  previously saved value. This provides a test of whether the contents of the
 *  file has changed.
 *
 *      input is a file name; output is a boolean
 *
 *@author Dan Higgins NCEAS UC Santa Barbara
 *
 */

public class MessageDigestTest extends TypedAtomicActor
{

 /**
  * The name of the file to be tested
  */
  public TypedIOPort testFileName = new TypedIOPort(this, "testFileName", true, false);

 /**
  * The result of the test (true or false)
  */
  public TypedIOPort testResult = new TypedIOPort(this, "testResult", false, true);
  
 /**
  *  A MD5 value to test against (in string format)
  */
  public StringParameter MD5_MessageDigest;
  
 /**
  * if the learningMode parameter is true, the calculated MD5 value is just placed
  * in the MD5_MessageDigest field as a hex string and no comparison is made; a false
  * is alway returned for this case (to indicate actor is in learning mode).
  * If true, a comparison is made; result of comparison is sent to the testResult
  * output port
  *
  */
  public Parameter learningMode;



  public MessageDigestTest(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException
  {
    super(container, name);
    
    
    testFileName.setTypeEquals(BaseType.STRING);
    testResult.setTypeEquals(BaseType.BOOLEAN);

    learningMode = new Parameter(this, "learningMode");
    learningMode.setTypeEquals(BaseType.BOOLEAN);
    learningMode.setToken(BooleanToken.FALSE);
    
    MD5_MessageDigest = new StringParameter(this, "MD5_MessageDigest");
    
  }
  

  /**
   *
   */
  public boolean prefire() throws IllegalActionException
  {
    return super.prefire();
  }

  /**
   *
   */
  public void fire() throws IllegalActionException
  {
    String fileNameStr = "";
    super.fire();
    
    boolean learningModeValue = ((BooleanToken)learningMode.getToken()).booleanValue();
    boolean comparison = false;
    try{
      if (testFileName.getWidth()>0) {
        fileNameStr = ((StringToken)testFileName.get(0)).stringValue();
      } else {
        System.out.println("No Input file name!");
        return;
      }
      String res = md5_file(fileNameStr);
      if (learningModeValue) {
        // just put the calculated value in the parameter\
        if (res!=null) {
            MD5_MessageDigest.setToken(new StringToken(res));
        }
      } else {
        // compare the calculated and saved values
        comparison = false;
        String oldval = MD5_MessageDigest.getExpression();
        if (oldval.equals(res)) comparison = true;
      }
    } catch (Exception w) {}

        
    testResult.broadcast(new BooleanToken(comparison));
  }
 
  /**
   * Post fire the actor. Return false to indicate that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   *
   *@return
   */
  public boolean postfire() throws IllegalActionException 
  {
    return super.postfire();
  }

  
 /** private classes */ 
    private String hex(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString((array[i] & 0xFF) | 0x100).toUpperCase().substring(1,3));
        }
        return sb.toString();
    }   

    private String md5_file (String filename) {
      try { 
        FileInputStream fis = new FileInputStream(filename);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int ch;
        while ((ch = bis.read()) != -1) {
          baos.write(ch);
        }
        byte[] buffer = baos.toByteArray();  
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        algorithm.update(buffer);
        byte[] digest = algorithm.digest();
        return hex (algorithm.digest(buffer));
      } catch (Exception w) {}
      return null;

    }

 
 }
