/**
 *    '$RCSfile: XSLT.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2005/11/01 20:39:16 $'
 *   '$Revision: 1.5 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package util;

//For java APIs
import java.io.BufferedReader;
import java.io.File;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import ptolemy.gui.MessageHandler;

public class XSLT {

    public XSLT() {
    }

    public String Transform(File xmlFile, File xslFile) {

        String htmlStr = "";
        String xsltURL = xslFile.getPath();
        System.out.println("XSLT URL:  " + xsltURL);
        // Creates instances of StreamSource for the stylesheet
        StreamSource xslt = new StreamSource(xsltURL);
        // Creates instances of StreamSource for the input document
        StreamSource xml = new StreamSource(xmlFile);
        try {
            // Creates an instance of TransformerFactory
            TransformerFactory factory =
                TransformerFactory.newInstance();
            // Creates an instance of Transformer
            Transformer transformer = factory.newTransformer(xslt);

            // Creating the output file object.
            UUIDGen uuidgen = new UUIDGen();
            String fileName = uuidgen.generateUUID();
            System.out.println(fileName);

            File fileOut = new File(fileName + ".html");
            // Executes the Transformer
            try {
                transformer.transform(xml, new StreamResult(fileOut));
            }
            catch (Exception e) {
              MessageHandler.error("Transform error", e);
            }
            BufferedReader br = new BufferedReader(new java.io.FileReader(fileOut));
            String line = br.readLine();
            while (line != null) {
      //        System.out.println(line);
                line = br.readLine();
                if (line != null)
                    htmlStr += line + "\n";
            }
            System.out.println(htmlStr);
            br.close();
            try {
              fileOut.delete();
            } catch (Exception ex) {
//                System.out.println("delete exception!! " , ex);
            }
        }
        catch (Exception e) {
    //      System.out.println(e);
        }
        return htmlStr;
    }

}