/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid;

import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LSID {
    private String lsid;
    private LSIDAuthority authority;
    private String namespace;
    private String object;
    private String revision;
    private LSID abstr;
    private String format;
    private String type;
    private LSID[] instances;

    public LSID(String string) throws MalformedLSIDException {
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            String string3 = stringTokenizer.nextToken().toLowerCase();
            if (!string2.equals("urn") || !string3.equals("lsid")) {
                throw new MalformedLSIDException("urn:lsid: not found: [" + string + "]");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedLSIDException(noSuchElementException, "urn:lsid: not found: [" + string + "]");
        }
        try {
            this.authority = new LSIDAuthority(stringTokenizer.nextToken().toLowerCase());
        }
        catch (MalformedLSIDException malformedLSIDException) {
            throw new MalformedLSIDException(malformedLSIDException, "invalid authority found: [" + string + "]");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedLSIDException(noSuchElementException, "authority not found: [" + string + "]");
        }
        try {
            this.namespace = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedLSIDException(noSuchElementException, "namespace not found: [" + string + "]");
        }
        try {
            this.object = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedLSIDException(noSuchElementException, "object not found: [" + string + "]");
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.revision = stringTokenizer.nextToken();
        }
        this.lsid = "urn:lsid:" + this.authority + ":" + this.namespace + ":" + this.object + (this.revision != null ? ":" + this.revision : "");
    }

    public LSID(String string, String string2, String string3, String string4) throws MalformedLSIDException {
        this.authority = new LSIDAuthority(string.toLowerCase());
        this.namespace = string2;
        this.object = string3;
        if (string4 != null) {
            this.revision = string4;
        }
        this.lsid = "urn:lsid:" + this.authority + ":" + this.namespace + ":" + this.object + (this.revision != null ? ":" + this.revision : "");
    }

    public String getLsid() {
        return this.lsid;
    }

    public LSIDAuthority getAuthority() {
        return this.authority;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getObject() {
        return this.object;
    }

    public String getRevision() {
        return this.revision;
    }

    public String toString() {
        return this.lsid;
    }

    public boolean equals(Object object) {
        if (object instanceof LSID) {
            LSID lSID = (LSID)object;
            return lSID.toString().equals(this.toString());
        }
        return false;
    }

    public LSID getAbstr() {
        return this.abstr;
    }

    public String getFormat() {
        return this.format;
    }

    public LSID[] getInstances() {
        return this.instances;
    }

    public String getType() {
        return this.type;
    }

    public void setAbstr(LSID lSID) {
        this.abstr = lSID;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setInstances(LSID[] lSIDArray) {
        this.instances = lSIDArray;
    }

    public void setType(String string) {
        this.type = string;
    }
}

