/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.conf.LSIDResolverConfig;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.ftp.FTPUtils;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.http.HTTPResponse;
import com.ibm.lsid.http.HTTPUtils;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.soap.SOAPUtils;
import com.ibm.lsid.wsdl.LSIDAuthorityPort;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import com.ibm.lsid.wsdl.SOAPLocation;
import com.ibm.lsid.wsdl.WSDLConstants;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.types.URI;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.dns;

public class LSIDResolver
implements WSDLConstants,
SOAPConstants,
HTTPConstants {
    public static final String ANY_AUTHORITY = "*";
    private LSIDAuthority authority;
    private LSID lsid;
    private LSIDWSDLWrapper wsdlWrapper;
    private LSIDCache cache;
    private boolean useCache;
    private LSIDCredentials runtimeCredentials;
    private LSIDCredentials lsidCredentials;
    private static LSIDResolverConfig config = new LSIDResolverConfig();
    private static final int NOTIFY = 0;
    private static final int REVOKE = 1;
    static /* synthetic */ Class class$org$apache$axis$types$URI;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public static void setResolverHome(String string) {
        String string2 = System.getProperty("LSID_CLIENT_HOME");
        if (string2 == null) {
            System.setProperty("LSID_CLIENT_HOME", string);
            config = new LSIDResolverConfig();
        }
    }

    public static LSIDResolverConfig getConfig() {
        return config;
    }

    public static LSIDAuthority resolveAuthority(LSIDAuthority lSIDAuthority) throws LSIDException {
        HTTPResponse hTTPResponse;
        Object object;
        if (lSIDAuthority.isResolved()) {
            return lSIDAuthority;
        }
        String string = (String)config.getHostMappings().get(lSIDAuthority.getAuthority());
        if (string == null) {
            string = (String)config.getHostMappings().get(ANY_AUTHORITY);
        }
        if (string != null) {
            lSIDAuthority.setUrl(string);
        } else {
            object = dns.getRecords((String)("_lsid._tcp." + lSIDAuthority), (short)33);
            if (object != null && ((Record[])object).length > 0 && object[0] != null && object[0] instanceof SRVRecord) {
                hTTPResponse = (SRVRecord)object[0];
                lSIDAuthority.setPort(hTTPResponse.getPort());
                String string2 = hTTPResponse.getTarget().toString();
                if (string2.charAt(string2.length() - 1) == '.') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                lSIDAuthority.setServer(string2);
            } else {
                lSIDAuthority.setPort(80);
                lSIDAuthority.setServer(lSIDAuthority.getAuthority());
            }
        }
        try {
            object = null;
            if (config.useCache()) {
                object = config.getCache().readWSDL(lSIDAuthority, null);
            }
            if (object == null) {
                hTTPResponse = HTTPUtils.doGet(lSIDAuthority.getUrl(), null, null, null);
                object = new LSIDWSDLWrapper(hTTPResponse.getData());
                ((LSIDWSDLWrapper)object).setExpiration(hTTPResponse.getExpiration());
                if (config.useCache()) {
                    config.getCache().writeWSDL(lSIDAuthority, null, (LSIDWSDLWrapper)object);
                }
            }
            lSIDAuthority.setWSDL((LSIDWSDLWrapper)object);
        }
        catch (LSIDException lSIDException) {
            System.err.println("Error getting WSDL for authority: " + string + ", will attempt default bindings");
            lSIDException.printStackTrace();
        }
        return lSIDAuthority;
    }

    public static void notifyForeignAuthority(LSIDAuthority lSIDAuthority, LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        LSIDResolver.notifyForeignAuthority(0, lSIDAuthority, lSID, lSIDCredentials);
    }

    public static void revokeNotificationForeignAuthority(LSIDAuthority lSIDAuthority, LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        LSIDResolver.notifyForeignAuthority(1, lSIDAuthority, lSID, lSIDCredentials);
    }

    private static void notifyForeignAuthority(int n, LSIDAuthority lSIDAuthority, LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        LSIDAuthority lSIDAuthority2 = lSID.getAuthority();
        if (!lSIDAuthority2.isResolved()) {
            LSIDResolver.resolveAuthority(lSIDAuthority2);
        }
        LSIDWSDLWrapper lSIDWSDLWrapper = lSIDAuthority2.getWSDL();
        LSIDAuthorityPort lSIDAuthorityPort = lSIDWSDLWrapper.getAuthorityPortForProtocol("soap");
        String string = lSIDAuthorityPort.getProtocol();
        Object var8_8 = null;
        if (lSIDCredentials == null) {
            lSIDCredentials = lSIDAuthorityPort.getLsidCredentials();
        }
        if (string.equals("soap")) {
            try {
                String string2 = "notifyForeignAuthority";
                if (n == 1) {
                    string2 = "revokeNotificationForeignAuthority";
                }
                Call call = SOAPUtils.createCall(lSIDAuthorityPort, lSIDCredentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings", string2));
                Vector<Object> vector = new Vector<Object>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                vector.add(new URI(lSID.toString()));
                call.addParameter("authorityName", Constants.XSD_STRING, class$java$lang$String == null ? (class$java$lang$String = LSIDResolver.class$("java.lang.String")) : class$java$lang$String, ParameterMode.IN);
                vector.add(lSIDAuthority.toString());
                call.invoke(vector.toArray());
                Message message = call.getResponseMessage();
            }
            catch (AxisFault axisFault) {
                throw SOAPUtils.processAxisFault(axisFault);
            }
            catch (RemoteException remoteException) {
                throw new LSIDException(remoteException, "Remote exception processing request");
            }
            catch (IOException iOException) {
                throw new LSIDException(iOException, "IO Error notifying authority");
            }
        } else if (string.equals("http")) {
            String string3 = lSIDAuthorityPort.getLocation();
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = n == 0 ? string3 + "/authority/notify/" : string3 + "/authority/revoke/";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("lsid", lSID);
            hashMap.put("authorityName", lSIDAuthority.toString());
            HTTPResponse hTTPResponse = HTTPUtils.doGet(string3, lSIDAuthorityPort.getProtocolHeaders(), hashMap, lSIDCredentials);
        } else {
            throw new LSIDException("Cannot notify authority over protocol: " + string);
        }
    }

    public static LSIDCache getCache() {
        return config.getCache();
    }

    public LSIDResolver(LSID lSID) throws LSIDException {
        this.lsid = lSID;
        this.authority = lSID.getAuthority();
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.lsidCredentials = new LSIDCredentials(lSID);
    }

    public LSIDResolver(LSIDAuthority lSIDAuthority, LSID lSID) throws LSIDException {
        this.authority = lSIDAuthority;
        this.lsid = lSID;
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.lsidCredentials = new LSIDCredentials(lSID);
    }

    public LSIDResolver(LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        this.lsid = lSID;
        this.authority = lSID.getAuthority();
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.runtimeCredentials = lSIDCredentials;
        this.lsidCredentials = new LSIDCredentials(lSID);
    }

    public LSIDResolver(LSIDAuthority lSIDAuthority, LSID lSID, LSIDCredentials lSIDCredentials) throws LSIDException {
        this.authority = lSIDAuthority;
        this.lsid = lSID;
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.runtimeCredentials = lSIDCredentials;
        this.lsidCredentials = new LSIDCredentials(lSID);
    }

    public void setUseLocalCache(boolean bl) {
        this.useCache = config.useCache() && bl;
    }

    public LSID getLSID() throws LSIDException {
        return this.lsid;
    }

    public LSIDAuthority getAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LSIDWSDLWrapper getWSDLWrapper() throws LSIDException {
        if (this.wsdlWrapper != null) {
            return this.wsdlWrapper;
        }
        LSIDResolver lSIDResolver = this;
        synchronized (lSIDResolver) {
            if (this.wsdlWrapper == null) {
                this.fetchWSDL();
            }
            return this.wsdlWrapper;
        }
    }

    public InputStream getData() throws LSIDException {
        this.getWSDLWrapper();
        LSIDDataPort lSIDDataPort = this.wsdlWrapper.getDataPort();
        return this.getData(lSIDDataPort, -1, -1);
    }

    public InputStream getData(int n, int n2) throws LSIDException {
        this.getWSDLWrapper();
        LSIDDataPort lSIDDataPort = this.wsdlWrapper.getDataPort();
        return this.getData(lSIDDataPort, n, n2);
    }

    public InputStream getData(LSIDDataPort lSIDDataPort) throws LSIDException {
        if (lSIDDataPort == null) {
            throw new LSIDException("Null data port provided");
        }
        return this.getData(lSIDDataPort, -1, -1);
    }

    public InputStream getData(LSIDDataPort lSIDDataPort, int n, int n2) throws LSIDException {
        if (lSIDDataPort == null) {
            throw new LSIDException("Null data port provided");
        }
        InputStream inputStream = null;
        if (this.useCache) {
            inputStream = this.cache.readData(this.lsid, n, n2);
        }
        if (inputStream == null) {
            this.getWSDLWrapper();
            inputStream = this.getDataFromPort(lSIDDataPort, n, n2);
            if (this.useCache) {
                return this.cache.writeData(this.lsid, inputStream, n, n2);
            }
        }
        return inputStream;
    }

    public LSIDMetadata getMetadataStore() throws LSIDException {
        MetadataResponse metadataResponse = this.getMetadata();
        String string = metadataResponse.getFormat();
        if (string == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata lSIDMetadata = config.getMetadataFactory(string).createInstance();
        lSIDMetadata.addMetadata(metadataResponse);
        return lSIDMetadata;
    }

    public LSIDMetadata getMetadataStore(String[] stringArray) throws LSIDException {
        MetadataResponse metadataResponse = this.getMetadata(stringArray);
        String string = metadataResponse.getFormat();
        if (string == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata lSIDMetadata = config.getMetadataFactory(string).createInstance();
        lSIDMetadata.addMetadata(metadataResponse);
        return lSIDMetadata;
    }

    public LSIDMetadata getMetadataStore(LSIDMetadataPort lSIDMetadataPort) throws LSIDException {
        MetadataResponse metadataResponse = this.getMetadata(lSIDMetadataPort);
        String string = metadataResponse.getFormat();
        if (string == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata lSIDMetadata = config.getMetadataFactory(string).createInstance();
        lSIDMetadata.addMetadata(metadataResponse);
        return lSIDMetadata;
    }

    public LSIDMetadata getMetadataStore(LSIDMetadataPort lSIDMetadataPort, String[] stringArray) throws LSIDException {
        MetadataResponse metadataResponse = this.getMetadata(lSIDMetadataPort, stringArray);
        String string = metadataResponse.getFormat();
        if (string == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata lSIDMetadata = config.getMetadataFactory(string).createInstance();
        lSIDMetadata.addMetadata(metadataResponse);
        return lSIDMetadata;
    }

    public MetadataResponse getMetadata() throws LSIDException {
        this.getWSDLWrapper();
        LSIDMetadataPort lSIDMetadataPort = this.wsdlWrapper.getMetadataPort();
        if (lSIDMetadataPort == null) {
            throw new LSIDException(400, "No meta data available for lsid: " + this.lsid);
        }
        return this.getMetadata(lSIDMetadataPort, new String[0]);
    }

    public MetadataResponse getMetadata(String[] stringArray) throws LSIDException {
        this.getWSDLWrapper();
        LSIDMetadataPort lSIDMetadataPort = this.wsdlWrapper.getMetadataPort();
        if (lSIDMetadataPort == null) {
            throw new LSIDException(400, "No meta data available for lsid: " + this.lsid);
        }
        return this.getMetadata(lSIDMetadataPort, stringArray);
    }

    public MetadataResponse getMetadata(LSIDMetadataPort lSIDMetadataPort) throws LSIDException {
        if (lSIDMetadataPort == null) {
            throw new LSIDException(400, "No meta data available for lsid: " + this.lsid);
        }
        return this.getMetadata(lSIDMetadataPort, new String[0]);
    }

    public MetadataResponse getMetadata(LSIDMetadataPort lSIDMetadataPort, String[] stringArray) throws LSIDException {
        if (lSIDMetadataPort == null) {
            throw new LSIDException("Null meta data port specified");
        }
        MetadataResponse metadataResponse = null;
        if (stringArray != null && stringArray.length < 1) {
            stringArray = config.getAcceptedFormats();
        }
        if (this.useCache) {
            metadataResponse = this.cache.readMetadata(this.authority, this.lsid, lSIDMetadataPort.getServiceName(), lSIDMetadataPort.getName(), stringArray);
        }
        if (metadataResponse == null) {
            this.getWSDLWrapper();
            String string = null;
            if (stringArray != null) {
                string = stringArray[0];
                int n = 1;
                while (n < stringArray.length) {
                    string = string + "," + stringArray[n];
                    ++n;
                }
            }
            metadataResponse = this.getMetadataFromPort(lSIDMetadataPort, string);
            if (this.useCache) {
                InputStream inputStream = this.cache.writeMetadata(this.authority, this.lsid, lSIDMetadataPort.getServiceName(), lSIDMetadataPort.getName(), (InputStream)metadataResponse.getValue(), metadataResponse.getExpires(), metadataResponse.getFormat());
                metadataResponse.setValue(inputStream);
            }
        }
        return metadataResponse;
    }

    private InputStream getDataFromPort(LSIDDataPort lSIDDataPort, int n, int n2) throws LSIDException {
        if (lSIDDataPort == null) {
            throw new LSIDException(300, "No data available for LSID  " + this.lsid);
        }
        String string = lSIDDataPort.getProtocol();
        String string2 = lSIDDataPort.getLocation();
        String string3 = lSIDDataPort.getPath();
        LSIDCredentials lSIDCredentials = null;
        lSIDCredentials = this.runtimeCredentials;
        Object var8_8 = null;
        if (lSIDCredentials == null) {
            lSIDCredentials = lSIDDataPort.getLsidCredentials();
        }
        if (lSIDCredentials == null) {
            lSIDCredentials = this.lsidCredentials;
        }
        if (string == null || string2 == null) {
            throw new LSIDException(300, "No Data Available for LSID: " + this.lsid);
        }
        if (string.equals("http")) {
            HashMap<String, Object> hashMap = null;
            if (lSIDDataPort.getPath().equals("urlEncoded")) {
                hashMap = new HashMap<String, Object>();
                if (n != -1 && n2 != -1) {
                    hashMap.put("start", String.valueOf(n));
                    hashMap.put("length", String.valueOf(n2));
                }
                hashMap.put("lsid", this.lsid);
            }
            HTTPResponse hTTPResponse = HTTPUtils.doGet(string2, lSIDDataPort.getProtocolHeaders(), hashMap, lSIDCredentials);
            return hTTPResponse.getData();
        }
        if (string.equals("ftp")) {
            if (n != -1 && n2 != -1) {
                throw new LSIDException(501, "getDataByRange not supported over FTP protocol, use InputStream API for chunking.");
            }
            return FTPUtils.doGet(string2, string3, lSIDCredentials);
        }
        if (string.equals("file")) {
            if (n != -1 && n2 != -1) {
                throw new LSIDException(501, "getDataByRange not supported over File protocol, use InputStream API for chunking.");
            }
            try {
                return new FileInputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new LSIDException(fileNotFoundException, 300, "Could not open data file " + string2);
            }
        }
        if (string.equals("soap")) {
            try {
                Call call = SOAPUtils.createCall(lSIDDataPort, lSIDCredentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/DataServiceSOAPBindings", "getData"));
                Vector<Object> vector = new Vector<Object>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                vector.add(new URI(this.lsid.toString()));
                if (n != -1 && n2 != -1) {
                    call.addParameter("start", Constants.XSD_INTEGER, class$java$lang$Integer == null ? (class$java$lang$Integer = LSIDResolver.class$("java.lang.Integer")) : class$java$lang$Integer, ParameterMode.IN);
                    vector.add(new Integer(n));
                    call.addParameter("length", Constants.XSD_INTEGER, class$java$lang$Integer == null ? (class$java$lang$Integer = LSIDResolver.class$("java.lang.Integer")) : class$java$lang$Integer, ParameterMode.IN);
                    vector.add(new Integer(n2));
                }
                call.invoke(vector.toArray());
                Message message = call.getResponseMessage();
                Attachments attachments = message.getAttachmentsImpl();
                AttachmentPart attachmentPart = (AttachmentPart)attachments.getAttachments().toArray()[0];
                DataHandler dataHandler = attachmentPart.getDataHandler();
                return dataHandler.getInputStream();
            }
            catch (MalformedURLException malformedURLException) {
                throw new LSIDException(malformedURLException, "bad authority url: " + lSIDDataPort.getLocation());
            }
            catch (AxisFault axisFault) {
                throw SOAPUtils.processAxisFault(axisFault);
            }
            catch (RemoteException remoteException) {
                throw new LSIDException(remoteException, "Remote exception processing request");
            }
            catch (SOAPException sOAPException) {
                throw new LSIDException((Exception)((Object)sOAPException), "Error processing response");
            }
            catch (IOException iOException) {
                throw new LSIDException(iOException, "Error getting input stream from attachment");
            }
        }
        throw new LSIDException(300, "No Data Available for LSID: " + this.lsid + " using port: " + lSIDDataPort.getName());
    }

    private MetadataResponse getMetadataFromPort(LSIDMetadataPort lSIDMetadataPort, String string) throws LSIDException {
        if (lSIDMetadataPort == null) {
            throw new LSIDException(400, "No meta data available for LSID  " + this.lsid);
        }
        String string2 = lSIDMetadataPort.getProtocol();
        String string3 = lSIDMetadataPort.getLocation();
        String string4 = lSIDMetadataPort.getPath();
        if (string2 == null || string3 == null) {
            throw new LSIDException(400, "No Meta Data Available for LSID: " + this.lsid + " using port: " + lSIDMetadataPort.getName());
        }
        LSIDCredentials lSIDCredentials = this.runtimeCredentials;
        if (lSIDCredentials == null) {
            lSIDCredentials = lSIDMetadataPort.getLsidCredentials();
        }
        if (lSIDCredentials == null) {
            lSIDCredentials = this.lsidCredentials;
        }
        if (string2.equals("http")) {
            HashMap<String, String> hashMap = null;
            if (lSIDMetadataPort.getPath().equals("urlEncoded")) {
                hashMap = new HashMap<String, String>();
                hashMap.put("lsid", this.lsid.toString());
                if (string != null) {
                    hashMap.put("acceptedFormats", string);
                }
            }
            HTTPResponse hTTPResponse = HTTPUtils.doGet(string3, lSIDMetadataPort.getProtocolHeaders(), hashMap, lSIDCredentials);
            String string5 = hTTPResponse.getContentType();
            int n = string5.indexOf(59);
            String string6 = null;
            string6 = n != -1 ? string5.substring(0, n) : string5;
            return new MetadataResponse((Object)hTTPResponse.getData(), hTTPResponse.getExpiration(), string6);
        }
        if (string2.equals("ftp")) {
            InputStream inputStream = FTPUtils.doGet(string3, string4, lSIDCredentials);
            return new MetadataResponse((Object)inputStream, null, null);
        }
        if (string2.equals("file")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string3);
                return new MetadataResponse((Object)fileInputStream, null, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new LSIDException(fileNotFoundException, 400, "Could not open metadata file " + string3);
            }
        }
        if (string2.equals("soap")) {
            try {
                Call call = SOAPUtils.createCall(lSIDMetadataPort, lSIDCredentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/DataServiceSOAPBindings", "getMetadata"));
                Vector<Object> vector = new Vector<Object>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                vector.add(new URI(this.lsid.toString()));
                if (string != null) {
                    call.addParameter("acceptedFormats", Constants.XSD_STRING, class$java$lang$String == null ? (class$java$lang$String = LSIDResolver.class$("java.lang.String")) : class$java$lang$String, ParameterMode.IN);
                    vector.add(string);
                }
                call.addParameter("format", Constants.XSD_STRING, class$java$lang$String == null ? (class$java$lang$String = LSIDResolver.class$("java.lang.String")) : class$java$lang$String, ParameterMode.OUT);
                call.addParameter("expiration", Constants.XSD_DATETIME, class$java$util$Date == null ? (class$java$util$Date = LSIDResolver.class$("java.util.Date")) : class$java$util$Date, ParameterMode.OUT);
                call.invoke(vector.toArray());
                Message message = call.getResponseMessage();
                Map map = call.getOutputParams();
                String string7 = (String)map.get(new QName(null, "format"));
                Date date = (Date)map.get(new QName(null, "expiration"));
                Attachments attachments = message.getAttachmentsImpl();
                AttachmentPart attachmentPart = (AttachmentPart)attachments.getAttachments().toArray()[0];
                DataHandler dataHandler = attachmentPart.getDataHandler();
                return new MetadataResponse((Object)dataHandler.getInputStream(), date, string7);
            }
            catch (MalformedURLException malformedURLException) {
                throw new LSIDException(malformedURLException, "bad authority url: " + lSIDMetadataPort.getLocation());
            }
            catch (AxisFault axisFault) {
                throw SOAPUtils.processAxisFault(axisFault);
            }
            catch (RemoteException remoteException) {
                throw new LSIDException(remoteException, "Remote exception processing request");
            }
            catch (SOAPException sOAPException) {
                throw new LSIDException((Exception)((Object)sOAPException), "Error processing response");
            }
            catch (IOException iOException) {
                throw new LSIDException(iOException, "Error getting input stream from attachment");
            }
        }
        return null;
    }

    private void resolveAuthority() throws LSIDException {
        this.authority = LSIDResolver.resolveAuthority(this.authority);
    }

    private void fetchWSDL() throws LSIDException {
        this.wsdlWrapper = null;
        Date date = null;
        int n = -1;
        LSIDAuthority lSIDAuthority = this.authority;
        LSIDAuthority[] lSIDAuthorityArray = config.getForeignAuthorities(this.lsid);
        do {
            Object object;
            LSIDWSDLWrapper lSIDWSDLWrapper;
            LSIDWSDLWrapper lSIDWSDLWrapper2 = null;
            if (this.useCache) {
                lSIDWSDLWrapper2 = this.cache.readWSDL(lSIDAuthority, this.lsid);
            }
            if (lSIDWSDLWrapper2 == null) {
                if (!lSIDAuthority.isResolved()) {
                    // empty if block
                }
                LSIDResolver.resolveAuthority(lSIDAuthority);
                try {
                    lSIDWSDLWrapper = this.authority.getWSDL();
                    object = null;
                    if (lSIDWSDLWrapper != null) {
                        object = lSIDWSDLWrapper.getAuthorityPortForProtocol("http");
                    }
                    if (object == null) {
                        object = new SOAPLocation(lSIDAuthority.getUrl());
                    }
                    lSIDWSDLWrapper2 = this.fetchWSDL((LSIDAuthorityPort)object);
                    if (this.useCache) {
                        this.cache.writeWSDL(lSIDAuthority, this.lsid, lSIDWSDLWrapper2);
                    }
                }
                catch (LSIDException lSIDException) {
                    if (n > -1 && lSIDException.getErrorCode() == 201) {
                        if (lSIDAuthorityArray != null && ++n < lSIDAuthorityArray.length) {
                            lSIDAuthority = lSIDAuthorityArray[n];
                            continue;
                        }
                        lSIDAuthority = null;
                        continue;
                    }
                    throw lSIDException;
                }
            }
            if (n == -1) {
                this.wsdlWrapper = lSIDWSDLWrapper2;
            } else {
                Object object2;
                lSIDWSDLWrapper = lSIDWSDLWrapper2;
                object = lSIDWSDLWrapper.getDataPortNames();
                while (object.hasMoreElements()) {
                    object2 = lSIDWSDLWrapper.getDataPort(object.nextElement().toString());
                    this.wsdlWrapper.setDataLocation((LSIDDataPort)object2);
                }
                object2 = lSIDWSDLWrapper.getMetadataPortNames();
                while (object2.hasMoreElements()) {
                    LSIDMetadataPort lSIDMetadataPort = lSIDWSDLWrapper.getMetadataPort(object2.nextElement().toString());
                    this.wsdlWrapper.setMetadataLocation(lSIDMetadataPort);
                }
            }
            ++n;
            lSIDAuthority = lSIDAuthorityArray != null && n < lSIDAuthorityArray.length ? lSIDAuthorityArray[n] : null;
        } while (lSIDAuthority != null);
        this.wsdlWrapper.setExpiration(date);
    }

    private LSIDWSDLWrapper fetchWSDL(LSIDAuthorityPort lSIDAuthorityPort) throws LSIDException {
        String string = lSIDAuthorityPort.getProtocol();
        LSIDCredentials lSIDCredentials = this.runtimeCredentials;
        Object var4_4 = null;
        if (lSIDCredentials == null) {
            lSIDCredentials = lSIDAuthorityPort.getLsidCredentials();
        }
        if (lSIDCredentials == null) {
            lSIDCredentials = this.lsidCredentials;
        }
        if (string.equals("soap")) {
            try {
                String string2;
                Call call = SOAPUtils.createCall(lSIDAuthorityPort, lSIDCredentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings", "getAvailableServices"));
                Vector<URI> vector = new Vector<URI>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                vector.add(new URI(this.lsid.toString()));
                call.invoke(vector.toArray());
                Message message = call.getResponseMessage();
                Date date = null;
                SOAPHeaderElement sOAPHeaderElement = message.getSOAPEnvelope().getHeaderByName(null, "expires");
                if (sOAPHeaderElement != null) {
                    string2 = sOAPHeaderElement.getValue();
                    date = SOAPUtils.parseDate(string2);
                }
                string2 = message.getAttachmentsImpl();
                AttachmentPart attachmentPart = (AttachmentPart)string2.getAttachments().toArray()[0];
                DataHandler dataHandler = attachmentPart.getDataHandler();
                LSIDWSDLWrapper lSIDWSDLWrapper = new LSIDWSDLWrapper(dataHandler.getInputStream());
                lSIDWSDLWrapper.setExpiration(date);
                return lSIDWSDLWrapper;
            }
            catch (MalformedURLException malformedURLException) {
                throw new LSIDException(malformedURLException, "bad authority url: " + lSIDAuthorityPort.getLocation());
            }
            catch (AxisFault axisFault) {
                throw SOAPUtils.processAxisFault(axisFault);
            }
            catch (RemoteException remoteException) {
                throw new LSIDException(remoteException, "Remote exception processing request");
            }
            catch (SOAPException sOAPException) {
                throw new LSIDException((Exception)((Object)sOAPException), "Error processing response");
            }
            catch (IOException iOException) {
                throw new LSIDException(iOException, "Error getting input stream from attachment");
            }
        }
        if (string.equals("http")) {
            String string3 = lSIDAuthorityPort.getLocation();
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = string3 + "/authority/";
            HashMap<String, LSID> hashMap = new HashMap<String, LSID>();
            hashMap.put("lsid", this.lsid);
            HTTPResponse hTTPResponse = HTTPUtils.doGet(string3, lSIDAuthorityPort.getProtocolHeaders(), hashMap, lSIDCredentials);
            LSIDWSDLWrapper lSIDWSDLWrapper = new LSIDWSDLWrapper(hTTPResponse.getData());
            lSIDWSDLWrapper.setExpiration(hTTPResponse.getExpiration());
            return lSIDWSDLWrapper;
        }
        throw new LSIDException("Cannot fetch wsdl over protocol: " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

